/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonatino.process.impl.win32;

import com.github.jonatino.misc.Cacheable;
import com.github.jonatino.misc.MemoryBuffer;
import com.github.jonatino.natives.win32.Kernel32;
import com.github.jonatino.process.AbstractProcess;
import com.github.jonatino.process.Module;
import com.github.jonatino.process.Process;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Tlhelp32;
import com.sun.jna.platform.win32.Win32Exception;

public final class Win32Process
extends AbstractProcess {
    private final Pointer handle;

    public Win32Process(int id, Pointer handle) {
        super(id);
        this.handle = handle;
    }

    public Pointer pointer() {
        return this.handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initModules() {
        Pointer snapshot = Kernel32.CreateToolhelp32Snapshot(Tlhelp32.TH32CS_SNAPMODULE32.intValue() | Tlhelp32.TH32CS_SNAPMODULE.intValue(), this.id());
        Tlhelp32.MODULEENTRY32W.ByReference entry = new Tlhelp32.MODULEENTRY32W.ByReference();
        try {
            while (Kernel32.Module32NextW(snapshot, (Tlhelp32.MODULEENTRY32W)entry)) {
                String name = entry.szModule();
                this.modules.put(name, new Module(this, name, entry.hModule.getPointer(), entry.modBaseSize.intValue()));
            }
        }
        finally {
            Kernel32.CloseHandle(snapshot);
        }
    }

    @Override
    public MemoryBuffer read(Pointer address, int size, MemoryBuffer buffer) {
        if (Kernel32.ReadProcessMemory(this.pointer(), address, buffer, size, 0) == 0L) {
            throw new Win32Exception(Native.getLastError());
        }
        return buffer;
    }

    @Override
    public Process write(Pointer address, MemoryBuffer buffer) {
        if (Kernel32.WriteProcessMemory(this.pointer(), address, buffer, buffer.size(), 0) == 0L) {
            throw new Win32Exception(Native.getLastError());
        }
        return this;
    }

    @Override
    public boolean canRead(Pointer address, int size) {
        return Kernel32.ReadProcessMemory(this.pointer(), address, Cacheable.buffer(size), size, 0) != 0L;
    }
}

