package com.github.jonpereiradev.diffobjects.builder;


import com.github.jonpereiradev.diffobjects.strategy.DiffMetadata;

import java.util.List;


/**
 * Responsible for generate the configuration of the instance.
 *
 * @author Jonathan Pereira
 * @see DiffBuilder
 * @see DiffInstanceBuilder
 * @see DiffMappingBuilder
 * @since 1.0
 */
public interface DiffConfiguration {

    /**
     * Gets the configuration for the instance instance.
     *
     * @return the metadata generated by the instance instance.
     */
    List<DiffMetadata> build();

}
