package com.github.jonpereiradev.diffobjects.builder;


/**
 * Builder responsible for mapping the fields of a class to create a configuration of diff.
 *
 * @author Jonathan Pereira
 * @see DiffBuilder
 * @see DiffInstanceBuilder
 * @see DiffConfiguration
 * @since 1.0
 */
public interface DiffMappingAllBuilder {

    /**
     * Gets the object responsible for query mappings for change.
     *
     * @param field the name of the field mapped in the builder.
     * @return the instance of the builder.
     */
    DiffQueryBuilder query(String field);

    /**
     * Gets the configuration instance to get the configuration generated by this instance instance.
     *
     * @return a configuration instance instance.
     */
    DiffConfiguration configuration();

}
