package com.github.jonpereiradev.diffobjects.builder;


/**
 * Builder responsible for modify the queried field of a class to create a configuration of diff.
 *
 * @author Jonathan Pereira
 * @see DiffBuilder
 * @see DiffInstanceBuilder
 * @see DiffConfiguration
 * @since 1.0
 */
public interface DiffQueryBuilder {

    /**
     * Define a property for the last mapping.
     *
     * @param key the identifier of the property.
     * @param value the value of the property.
     * @return the instance of this builder.
     */
    DiffQueryBuilder property(String key, String value);

    /**
     * Removes the mapping that this current query represents.
     *
     * @return the instance of this builder.
     */
    DiffMappingAllBuilder unmapping();

    /**
     * Gets the configuration instance to get the configuration generated by this instance instance.
     *
     * @return a configuration instance instance.
     */
    DiffConfiguration configuration();
}
