package com.github.jonpereiradev.diffobjects.builder;


/**
 * Builder responsible for modify the queried field of a class to create a configuration of diff.
 *
 * @author Jonathan Pereira
 * @see DiffBuilder
 * @see DiffInstanceBuilder
 * @see DiffConfiguration
 * @since 1.0
 */
public interface DiffQueryMappingBuilder {

    /**
     * Define a property for the last mapping.
     *
     * @param key the identifier of the property.
     * @param value the value of the property.
     * @return the instance of this builder.
     */
    DiffQueryMappingBuilder property(String key, String value);

    /**
     * Removes the mapping that this current query represents.
     *
     * @return the instance of this builder.
     */
    DiffMappingBuilder unmapping();

    /**
     * Maps a new getter of the field for the class.
     *
     * @param field name of the field that will me used to find the getter method.
     * @return the instance of this mapping.
     */
    DiffQueryMappingBuilder mapping(String field);

    /**
     * Maps a new getter of the field for the class with the value property to allow deep diff.
     *
     * @param field name of the field that will me used to find the getter method.
     * @param value the nested property of the object to make the diff.
     * @return the instance of this mapping.
     */
    DiffQueryMappingBuilder mapping(String field, String value);

    /**
     * Gets the configuration instance to get the configuration generated by this instance instance.
     *
     * @return a configuration instance instance.
     */
    DiffConfiguration configuration();
}
