/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonpereiradev.diffobjects;

import com.github.jonpereiradev.diffobjects.DiffResult;
import com.github.jonpereiradev.diffobjects.builder.DiffConfiguration;
import com.github.jonpereiradev.diffobjects.builder.DiffReflections;
import com.github.jonpereiradev.diffobjects.strategy.DiffMetadata;
import com.github.jonpereiradev.diffobjects.strategy.DiffStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class DiffObjects {
    private DiffObjects() {
        throw new UnsupportedOperationException("No need to create an instance of this class.");
    }

    public static <T> List<DiffResult> diff(T beforeState, T afterState) {
        Objects.requireNonNull(beforeState, "Before state is required.");
        Objects.requireNonNull(afterState, "After state is required.");
        return DiffObjects.diff(beforeState, afterState, DiffReflections.mapAnnotations(beforeState.getClass()));
    }

    public static <T> List<DiffResult> diff(T beforeState, T afterState, DiffConfiguration configuration) {
        Objects.requireNonNull(beforeState, "Before state is required.");
        Objects.requireNonNull(afterState, "After state is required.");
        Objects.requireNonNull(configuration, "Configuration is required.");
        List<DiffMetadata> metadatas = configuration.build();
        ArrayList<DiffResult> results = new ArrayList<DiffResult>(metadatas.size());
        for (DiffMetadata metadata : metadatas) {
            DiffStrategy strategy = metadata.getStrategy();
            DiffResult diff = strategy.diff(beforeState, afterState, metadata);
            diff.setProperties(Collections.unmodifiableMap(metadata.getProperties()));
            results.add(diff);
        }
        return results;
    }

    public static <T> boolean isEquals(T beforeState, T afterState) {
        Objects.requireNonNull(beforeState, "Before state is required.");
        Objects.requireNonNull(afterState, "After state is required.");
        return DiffObjects.isEquals(beforeState, afterState, DiffReflections.mapAnnotations(beforeState.getClass()));
    }

    public static <T> boolean isEquals(T beforeState, T afterState, DiffConfiguration configuration) {
        Objects.requireNonNull(beforeState, "Before state is required.");
        Objects.requireNonNull(afterState, "After state is required.");
        Objects.requireNonNull(configuration, "Configuration is required.");
        for (DiffMetadata metadata : configuration.build()) {
            DiffStrategy strategy = metadata.getStrategy();
            DiffResult result = strategy.diff(beforeState, afterState, metadata);
            if (result.isEquals()) continue;
            return false;
        }
        return true;
    }
}

