/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonpereiradev.diffobjects.builder;

import com.github.jonpereiradev.diffobjects.builder.DiffInstanceBuilder;
import com.github.jonpereiradev.diffobjects.builder.DiffMappingAllBuilder;
import com.github.jonpereiradev.diffobjects.builder.DiffMappingAllBuilderImpl;
import com.github.jonpereiradev.diffobjects.builder.DiffMappingBuilderImpl;
import com.github.jonpereiradev.diffobjects.builder.DiffQueryMappingBuilder;
import com.github.jonpereiradev.diffobjects.strategy.DiffMetadata;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public final class DiffBuilder
implements DiffInstanceBuilder {
    private final Class<?> classMap;
    private final Map<String, DiffMetadata> metadatas;

    private DiffBuilder(Class<?> classMap) {
        this.classMap = classMap;
        this.metadatas = new LinkedHashMap<String, DiffMetadata>();
    }

    public static DiffBuilder map(Class<?> clazz) {
        Objects.requireNonNull(clazz, "Class is required.");
        return new DiffBuilder(clazz);
    }

    @Override
    public DiffMappingAllBuilder mappingAll() {
        for (Class<?> clazz = this.classMap; clazz != null && !clazz.equals(Object.class); clazz = clazz.getSuperclass()) {
            for (Field parentField : clazz.getDeclaredFields()) {
                if (this.metadatas.containsKey(parentField.getName())) continue;
                this.mapping(parentField.getName());
            }
        }
        return new DiffMappingAllBuilderImpl(this.metadatas);
    }

    @Override
    public DiffQueryMappingBuilder mapping(String field) {
        return new DiffMappingBuilderImpl(this.classMap, this.metadatas).mapping(field);
    }

    @Override
    public DiffQueryMappingBuilder mapping(String field, String value) {
        return new DiffMappingBuilderImpl(this.classMap, this.metadatas).mapping(field, value);
    }

    Map<String, DiffMetadata> getMetadatas() {
        return this.metadatas;
    }
}

