/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonpereiradev.diffobjects.builder;

import com.github.jonpereiradev.diffobjects.DiffException;
import com.github.jonpereiradev.diffobjects.builder.DiffConfiguration;
import com.github.jonpereiradev.diffobjects.builder.DiffConfigurationImpl;
import com.github.jonpereiradev.diffobjects.builder.DiffMappingBuilder;
import com.github.jonpereiradev.diffobjects.builder.DiffQueryMappingBuilder;
import com.github.jonpereiradev.diffobjects.builder.DiffQueryMappingBuilderImpl;
import com.github.jonpereiradev.diffobjects.builder.DiffReflections;
import com.github.jonpereiradev.diffobjects.strategy.DiffMetadata;
import com.github.jonpereiradev.diffobjects.strategy.DiffStrategyType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;

final class DiffMappingBuilderImpl
implements DiffMappingBuilder {
    private final Class<?> classMap;
    private final Map<String, DiffMetadata> metadatas;

    DiffMappingBuilderImpl(Class<?> classMap, Map<String, DiffMetadata> metadatas) {
        this.classMap = classMap;
        this.metadatas = metadatas;
    }

    @Override
    public DiffQueryMappingBuilder mapping(String field) {
        return this.mapping(field, "");
    }

    @Override
    public DiffQueryMappingBuilder mapping(String field, String nestedField) {
        Objects.requireNonNull(field, "Field name is required.");
        Method method = DiffReflections.discoverGetter(this.classMap, field);
        DiffStrategyType diffStrategyType = DiffStrategyType.SINGLE;
        if (!Modifier.isPublic(method.getModifiers()) || method.getParameterTypes().length > 0) {
            throw new DiffException("Method " + method.getName() + " must be public and no-args.");
        }
        if (nestedField != null && !nestedField.isEmpty()) {
            diffStrategyType = DiffStrategyType.DEEP;
        }
        if (Collection.class.isAssignableFrom(method.getReturnType())) {
            diffStrategyType = DiffStrategyType.COLLECTION;
        }
        DiffMetadata diffMetadata = new DiffMetadata(nestedField, method, diffStrategyType);
        diffMetadata.getProperties().put("field", field);
        this.metadatas.put(field, diffMetadata);
        return new DiffQueryMappingBuilderImpl(diffMetadata, this, this.metadatas);
    }

    @Override
    public DiffConfiguration configuration() {
        return new DiffConfigurationImpl(this.metadatas);
    }
}

