/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonpereiradev.diffobjects.builder;

import com.github.jonpereiradev.diffobjects.DiffException;
import com.github.jonpereiradev.diffobjects.annotation.DiffMapping;
import com.github.jonpereiradev.diffobjects.annotation.DiffMappings;
import com.github.jonpereiradev.diffobjects.annotation.DiffProperty;
import com.github.jonpereiradev.diffobjects.builder.DiffBuilder;
import com.github.jonpereiradev.diffobjects.builder.DiffConfiguration;
import com.github.jonpereiradev.diffobjects.builder.DiffConfigurationImpl;
import com.github.jonpereiradev.diffobjects.builder.DiffQueryMappingBuilder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.reflect.MethodUtils;

public final class DiffReflections {
    public static DiffConfiguration mapAnnotations(Class<?> diffClass) {
        DiffBuilder builder = DiffBuilder.map(diffClass);
        if (diffClass.isAnnotationPresent(DiffMappings.class)) {
            DiffReflections.mapAllMethods(diffClass, builder);
        } else {
            DiffReflections.mapAnnotationsMethods(diffClass, builder);
        }
        return new DiffConfigurationImpl(builder.getMetadatas());
    }

    public static Method discoverGetter(Class<?> diffClass, String fieldOrMethodName) {
        Method method;
        String possibleAccessMethodName = fieldOrMethodName;
        if (!fieldOrMethodName.startsWith("get")) {
            possibleAccessMethodName = "get" + StringUtils.capitalize((String)fieldOrMethodName);
        }
        if ((method = MethodUtils.getMatchingAccessibleMethod(diffClass, (String)possibleAccessMethodName, null)) == null) {
            throw new DiffException("Method " + possibleAccessMethodName + " not found in class " + diffClass.getName());
        }
        return method;
    }

    public static <T> T invoke(Object instance, Method method) {
        try {
            return (T)method.invoke(instance, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw new DiffException("Method " + method.getName() + " must be public and no-args.");
        }
    }

    private static DiffConfiguration mapAllMethods(Class<?> diffClass, DiffBuilder builder) {
        for (Method method : diffClass.getMethods()) {
            builder.mapping(method.getName());
        }
        return new DiffConfigurationImpl(builder.getMetadatas());
    }

    private static DiffConfiguration mapAnnotationsMethods(Class<?> diffClass, DiffBuilder builder) {
        for (Method method : diffClass.getMethods()) {
            if (method.isAnnotationPresent(DiffMapping.class)) {
                DiffMapping diffMapping = method.getAnnotation(DiffMapping.class);
                DiffQueryMappingBuilder query = builder.mapping(method.getName(), diffMapping.value());
                for (DiffProperty diffProperty : diffMapping.properties()) {
                    query.property(diffProperty.key(), diffProperty.value());
                }
                continue;
            }
            if (!method.isAnnotationPresent(DiffMappings.class)) continue;
            for (DiffMapping diffMapping : method.getAnnotation(DiffMappings.class).value()) {
                builder.mapping(method.getName(), diffMapping.value());
                DiffQueryMappingBuilder query = builder.mapping(method.getName(), diffMapping.value());
                for (DiffProperty diffProperty : diffMapping.properties()) {
                    query.property(diffProperty.key(), diffProperty.value());
                }
            }
        }
        return new DiffConfigurationImpl(builder.getMetadatas());
    }
}

