/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonpereiradev.diffobjects.strategy;

import com.github.jonpereiradev.diffobjects.DiffResult;
import com.github.jonpereiradev.diffobjects.builder.DiffReflections;
import com.github.jonpereiradev.diffobjects.strategy.DiffMetadata;
import com.github.jonpereiradev.diffobjects.strategy.DiffStrategy;
import com.github.jonpereiradev.diffobjects.strategy.DiffStrategyType;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;

final class DiffCollectionStrategy
implements DiffStrategy {
    DiffCollectionStrategy() {
    }

    @Override
    public DiffResult diff(Object before, Object after, DiffMetadata diffMetadata) {
        Collection<?> beforeCollection = this.initializeCollection(before, diffMetadata.getMethod());
        Collection<?> afterCollection = this.initializeCollection(after, diffMetadata.getMethod());
        if (beforeCollection == null && afterCollection == null) {
            return new DiffResult(null, null, true);
        }
        if (!this.isEqualsSize(beforeCollection, afterCollection)) {
            return new DiffResult(beforeCollection, afterCollection, false);
        }
        Iterator<?> beforeIterator = beforeCollection.iterator();
        Iterator<?> afterIterator = afterCollection.iterator();
        while (beforeIterator.hasNext() && afterIterator.hasNext()) {
            Object beforeObject = beforeIterator.next();
            Object afterObject = afterIterator.next();
            if (!diffMetadata.getValue().isEmpty()) {
                String value = diffMetadata.getValue();
                String nextValue = value.contains(".") ? value.substring(value.indexOf(".")) : null;
                DiffStrategyType diffStrategyType = DiffStrategyType.defineByValue(nextValue);
                Method method = DiffReflections.discoverGetter(beforeObject.getClass(), value);
                DiffMetadata metadata = new DiffMetadata(nextValue, method, diffStrategyType);
                DiffStrategy strategy = metadata.getStrategy();
                DiffResult single = strategy.diff(beforeObject, afterObject, metadata);
                if (single.isEquals()) continue;
                return new DiffResult(beforeCollection, afterCollection, false);
            }
            if (beforeObject.equals(afterObject)) continue;
            return new DiffResult(beforeCollection, afterCollection, false);
        }
        return new DiffResult(beforeCollection, afterCollection, true);
    }

    private Collection<?> initializeCollection(Object object, Method method) {
        Collection collection = null;
        if (object != null) {
            collection = (Collection)DiffReflections.invoke(object, method);
        }
        if (collection != null && collection.isEmpty()) {
            return null;
        }
        return collection;
    }

    private boolean isEqualsSize(Collection<?> beforeCollection, Collection<?> afterCollection) {
        if (beforeCollection == null && afterCollection != null) {
            return false;
        }
        if (beforeCollection != null && afterCollection == null) {
            return false;
        }
        return beforeCollection.size() == afterCollection.size();
    }
}

