/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonpereiradev.diffobjects.strategy;

import com.github.jonpereiradev.diffobjects.DiffResult;
import com.github.jonpereiradev.diffobjects.builder.DiffReflections;
import com.github.jonpereiradev.diffobjects.strategy.DiffMetadata;
import com.github.jonpereiradev.diffobjects.strategy.DiffStrategy;
import java.lang.reflect.Method;
import java.util.Objects;

final class DiffDeepStrategy
implements DiffStrategy {
    private static final String REGEX_PROPERTY_SEPARATOR = "\\.";

    DiffDeepStrategy() {
    }

    @Override
    public DiffResult diff(Object before, Object after, DiffMetadata diffMetadata) {
        Method beforeMethod = diffMetadata.getMethod();
        Method afterMethod = diffMetadata.getMethod();
        Object beforeObject = null;
        Object afterObject = null;
        if (before != null) {
            beforeObject = DiffReflections.invoke(before, beforeMethod);
        }
        if (after != null) {
            afterObject = DiffReflections.invoke(after, afterMethod);
        }
        if (beforeObject != null || afterObject != null) {
            for (String property : diffMetadata.getValue().split(REGEX_PROPERTY_SEPARATOR)) {
                if (beforeObject != null) {
                    beforeMethod = DiffReflections.discoverGetter(beforeObject.getClass(), property);
                    beforeObject = DiffReflections.invoke(beforeObject, beforeMethod);
                }
                if (afterObject == null) continue;
                afterMethod = DiffReflections.discoverGetter(afterObject.getClass(), property);
                afterObject = DiffReflections.invoke(afterObject, afterMethod);
            }
        }
        return new DiffResult(beforeObject, afterObject, Objects.deepEquals(beforeObject, afterObject));
    }
}

