package com.github.jonpereiradev.diffobjects.builder;


import com.github.jonpereiradev.diffobjects.comparator.DiffComparator;

/**
 * Builder responsible for modify the queried field of a class to create a configuration of diff.
 *
 * @author Jonathan Pereira
 * @see DiffBuilder
 * @see DiffInstanceBuilder
 * @see DiffConfiguration
 * @since 1.0
 */
public interface DiffQueryMappingBuilder<T> {

    /**
     * Define a property for the last mapping.
     *
     * @param key the identifier of the property.
     * @param value the value of the property.
     *
     * @return the instance of this builder.
     */
    DiffQueryMappingBuilder<T> property(String key, String value);

    /**
     * Removes the mapping that this current query represents.
     *
     * @return the instance of this builder.
     */
    DiffMappingBuilder<T> unmapping();

    /**
     * Maps a new getter of the field for the class.
     *
     * @param field name of the field that will me used to find the getter method.
     *
     * @return the instance of this mapping.
     */
    DiffQueryMappingBuilder<T> mapping(String field);

    /**
     * Maps a new getter of the field for the class.
     *
     * @param field name of the field that will me used to find the getter method.
     * @param comparator implementation that define how two objects will be check for equality.
     *
     * @return the instance of this mapping.
     */
    <F> DiffQueryMappingBuilder<T> mapping(String field, Class<F> fieldClass, DiffComparator<F> comparator);

    /**
     * Gets the configuration instance to get the configuration generated by this instance instance.
     *
     * @return a configuration instance instance.
     */
    DiffConfiguration configuration();
}
