/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonpereiradev.diffobjects;

import com.github.jonpereiradev.diffobjects.DiffResult;
import com.github.jonpereiradev.diffobjects.builder.DiffConfiguration;
import com.github.jonpereiradev.diffobjects.builder.DiffReflections;
import com.github.jonpereiradev.diffobjects.comparator.DiffComparator;
import com.github.jonpereiradev.diffobjects.strategy.DiffMetadata;
import com.github.jonpereiradev.diffobjects.strategy.DiffStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public final class DiffObjects<T> {
    private final DiffConfiguration annotations;

    private DiffObjects(Class<T> clazz) {
        this.annotations = DiffReflections.mapAnnotations(clazz);
    }

    public static <T> DiffObjects<T> forClass(Class<T> clazz) {
        return new DiffObjects<T>(clazz);
    }

    public List<DiffResult> diff(T beforeState, T afterState) {
        Objects.requireNonNull(beforeState, "Before state is required.");
        Objects.requireNonNull(afterState, "After state is required.");
        return this.diff(beforeState, afterState, this.annotations);
    }

    public List<DiffResult> diff(T beforeState, T afterState, DiffConfiguration configuration) {
        Objects.requireNonNull(beforeState, "Before state is required.");
        Objects.requireNonNull(afterState, "After state is required.");
        Objects.requireNonNull(configuration, "Configuration is required.");
        List<DiffMetadata> metadatas = configuration.build();
        ArrayList<DiffResult> results = new ArrayList<DiffResult>(metadatas.size());
        for (DiffMetadata metadata : metadatas) {
            DiffStrategy strategy = metadata.getStrategy();
            DiffResult diff = strategy.diff(beforeState, afterState, metadata);
            diff.setProperties(Collections.unmodifiableMap(metadata.getProperties()));
            results.add(diff);
        }
        return results;
    }

    public List<DiffResult> diff(Collection<T> beforeState, Collection<T> afterState, DiffComparator<T> matcher) {
        Objects.requireNonNull(beforeState, "Before state is required.");
        Objects.requireNonNull(afterState, "After state is required.");
        return this.diff(beforeState, afterState, this.annotations, matcher);
    }

    public List<DiffResult> diff(Collection<T> beforeState, Collection<T> afterState, DiffConfiguration configuration, DiffComparator<T> matcher) {
        Stream<Object> stream;
        Objects.requireNonNull(beforeState, "Before state is required.");
        Objects.requireNonNull(afterState, "After state is required.");
        Objects.requireNonNull(configuration, "Configuration is required.");
        ArrayList<DiffResult> results = new ArrayList<DiffResult>();
        for (Object before2 : beforeState) {
            stream = afterState.stream().filter(after -> matcher.equals(before2, after));
            Object after2 = stream.findFirst().orElse(null);
            if (after2 == null) {
                results.add(new DiffResult(before2, null, false));
                continue;
            }
            boolean equals = true;
            for (DiffMetadata metadata : configuration.build()) {
                DiffStrategy strategy = metadata.getStrategy();
                DiffResult diff = strategy.diff(before2, after2, metadata);
                if (diff.isEquals()) continue;
                equals = false;
                break;
            }
            results.add(new DiffResult(before2, after2, equals));
        }
        for (Object after3 : afterState) {
            stream = beforeState.stream().filter(before -> matcher.equals(after3, before));
            Object before3 = stream.findFirst().orElse(null);
            if (before3 != null) continue;
            results.add(new DiffResult(null, after3, false));
        }
        return results;
    }

    public boolean isEquals(T beforeState, T afterState) {
        Objects.requireNonNull(beforeState, "Before state is required.");
        Objects.requireNonNull(afterState, "After state is required.");
        return this.isEquals(beforeState, afterState, this.annotations);
    }

    public boolean isEquals(T beforeState, T afterState, DiffConfiguration configuration) {
        Objects.requireNonNull(beforeState, "Before state is required.");
        Objects.requireNonNull(afterState, "After state is required.");
        Objects.requireNonNull(configuration, "Configuration is required.");
        for (DiffMetadata metadata : configuration.build()) {
            DiffStrategy strategy = metadata.getStrategy();
            DiffResult result = strategy.diff(beforeState, afterState, metadata);
            if (result.isEquals()) continue;
            return false;
        }
        return true;
    }

    public boolean isEquals(Collection<T> beforeState, Collection<T> afterState, DiffComparator<T> matcher) {
        Objects.requireNonNull(beforeState, "Before state is required.");
        Objects.requireNonNull(afterState, "After state is required.");
        return this.isEquals(beforeState, afterState, this.annotations, matcher);
    }

    public boolean isEquals(Collection<T> beforeState, Collection<T> afterState, DiffConfiguration configuration, DiffComparator<T> matcher) {
        Stream<Object> stream;
        Objects.requireNonNull(beforeState, "Before state is required.");
        Objects.requireNonNull(afterState, "After state is required.");
        Objects.requireNonNull(configuration, "Configuration is required.");
        ArrayList<T> afterCopy = new ArrayList<T>(afterState);
        for (Object before2 : beforeState) {
            stream = afterState.stream().filter(after -> matcher.equals(before2, after));
            T after2 = stream.findFirst().orElse(null);
            if (after2 == null) {
                return false;
            }
            afterCopy.remove(after2);
            if (this.isEquals(before2, after2, configuration)) continue;
            return false;
        }
        for (Object after3 : afterCopy) {
            stream = beforeState.stream().filter(before -> matcher.equals(after3, before));
            Object before3 = stream.findFirst().orElse(null);
            if (before3 != null) continue;
            return false;
        }
        return true;
    }
}

