/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonpereiradev.diffobjects.builder;

import com.github.jonpereiradev.diffobjects.builder.DiffInstanceBuilder;
import com.github.jonpereiradev.diffobjects.builder.DiffMappingAllBuilder;
import com.github.jonpereiradev.diffobjects.builder.DiffMappingAllBuilderImpl;
import com.github.jonpereiradev.diffobjects.builder.DiffMappingBuilderImpl;
import com.github.jonpereiradev.diffobjects.builder.DiffQueryMappingBuilder;
import com.github.jonpereiradev.diffobjects.comparator.DiffComparator;
import com.github.jonpereiradev.diffobjects.strategy.DiffMetadata;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public final class DiffBuilder<T>
implements DiffInstanceBuilder<T> {
    private final Class<T> classMap;
    private final Map<String, DiffMetadata> metadatas;

    private DiffBuilder(Class<T> classMap) {
        this.classMap = classMap;
        this.metadatas = new LinkedHashMap<String, DiffMetadata>();
    }

    public static <T> DiffBuilder<T> map(Class<T> clazz) {
        Objects.requireNonNull(clazz, "Class is required.");
        return new DiffBuilder<T>(clazz);
    }

    @Override
    public DiffMappingAllBuilder mappingAll() {
        for (Class<T> clazz = this.classMap; clazz != null && !clazz.equals(Object.class); clazz = clazz.getSuperclass()) {
            for (Field parentField : clazz.getDeclaredFields()) {
                if (this.metadatas.containsKey(parentField.getName())) continue;
                this.mapping(parentField.getName());
            }
        }
        return new DiffMappingAllBuilderImpl(this.metadatas);
    }

    @Override
    public DiffQueryMappingBuilder<T> mapping(String field) {
        return new DiffMappingBuilderImpl<T>(this.classMap, this.metadatas).mapping(field);
    }

    @Override
    public <F> DiffQueryMappingBuilder<T> mapping(String field, Class<F> fieldClass, DiffComparator<F> comparator) {
        return new DiffMappingBuilderImpl<T>(this.classMap, this.metadatas).mapping(field, fieldClass, comparator);
    }

    Map<String, DiffMetadata> getMetadatas() {
        return this.metadatas;
    }
}

