/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonpereiradev.diffobjects.builder;

import com.github.jonpereiradev.diffobjects.annotation.DiffOrder;
import com.github.jonpereiradev.diffobjects.builder.DiffConfiguration;
import com.github.jonpereiradev.diffobjects.strategy.DiffMetadata;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

final class DiffConfigurationImpl
implements DiffConfiguration {
    private final Map<String, DiffMetadata> metadatas;
    private final List<DiffMetadata> diffMetadatas;

    DiffConfigurationImpl(Map<String, DiffMetadata> metadatas) {
        this.metadatas = metadatas;
        this.diffMetadatas = new ArrayList<DiffMetadata>(metadatas.keySet().size());
    }

    @Override
    public List<DiffMetadata> build() {
        if (this.diffMetadatas.isEmpty()) {
            boolean sortable = false;
            for (Map.Entry<String, DiffMetadata> entry : this.metadatas.entrySet()) {
                DiffOrder annotation = entry.getValue().getMethod().getAnnotation(DiffOrder.class);
                if (annotation != null) {
                    entry.getValue().setOrder(annotation.value());
                    sortable = true;
                }
                this.diffMetadatas.add(entry.getValue());
            }
            if (sortable) {
                Collections.sort(this.diffMetadatas);
            }
        }
        return this.diffMetadatas;
    }
}

