/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonpereiradev.diffobjects.builder;

import com.github.jonpereiradev.diffobjects.builder.DiffConfiguration;
import com.github.jonpereiradev.diffobjects.builder.DiffConfigurationImpl;
import com.github.jonpereiradev.diffobjects.builder.DiffMappingBuilder;
import com.github.jonpereiradev.diffobjects.builder.DiffQueryMappingBuilder;
import com.github.jonpereiradev.diffobjects.builder.DiffQueryMappingBuilderImpl;
import com.github.jonpereiradev.diffobjects.builder.DiffReflections;
import com.github.jonpereiradev.diffobjects.comparator.DiffComparator;
import com.github.jonpereiradev.diffobjects.comparator.EqualsComparator;
import com.github.jonpereiradev.diffobjects.comparator.IndexComparator;
import com.github.jonpereiradev.diffobjects.strategy.DiffMetadata;
import com.github.jonpereiradev.diffobjects.strategy.DiffStrategyType;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

final class DiffMappingBuilderImpl<T>
implements DiffMappingBuilder<T> {
    private static final String REGEX_PROPERTY_SEPARATOR = "\\.";
    private final Class<T> classMap;
    private final Map<String, DiffMetadata> metadatas;
    private final Map<String, DiffMetadata> collections;

    DiffMappingBuilderImpl(Class<T> classMap, Map<String, DiffMetadata> metadatas) {
        this.classMap = classMap;
        this.metadatas = metadatas;
        this.collections = new HashMap<String, DiffMetadata>();
    }

    @Override
    public DiffQueryMappingBuilder<T> mapping(String field) {
        String[] fields = field.split(REGEX_PROPERTY_SEPARATOR);
        Method method = DiffReflections.discoverGetter(this.classMap, fields[0]);
        if (Collection.class.isAssignableFrom(method.getReturnType()) && fields.length == 1) {
            return this.mapping(field, method.getReturnType(), new IndexComparator());
        }
        return this.mapping(field, method.getReturnType(), new EqualsComparator());
    }

    @Override
    public <F> DiffQueryMappingBuilder<T> mapping(String field, Class<F> fieldClass, DiffComparator<F> comparator) {
        IndexComparator collection;
        Objects.requireNonNull(field, "Field name is required.");
        String nestedField = "";
        String[] fields = field.split(REGEX_PROPERTY_SEPARATOR);
        Method method = DiffReflections.discoverGetter(this.classMap, fields[0]);
        DiffStrategyType diffStrategyType = DiffStrategyType.SINGLE;
        IndexComparator indexComparator = collection = this.collections.containsKey(fields[0]) ? this.collections.get(fields[0]).getComparator() : null;
        if (fields.length > 1) {
            diffStrategyType = DiffStrategyType.NESTED;
            nestedField = field.substring(field.indexOf(".") + 1);
        }
        if (Collection.class.isAssignableFrom(method.getReturnType())) {
            diffStrategyType = DiffStrategyType.COLLECTION;
            collection = collection != null ? collection : new IndexComparator();
        }
        DiffMetadata diffMetadata = new DiffMetadata(nestedField, method, diffStrategyType, comparator, collection);
        diffMetadata.getProperties().put("field", field);
        if (Collection.class.isAssignableFrom(method.getReturnType())) {
            if (nestedField.isEmpty()) {
                this.collections.put(fields[0], diffMetadata);
            } else {
                this.metadatas.remove(fields[0]);
            }
        }
        this.metadatas.put(field, diffMetadata);
        return new DiffQueryMappingBuilderImpl(diffMetadata, this);
    }

    @Override
    public DiffConfiguration configuration() {
        return new DiffConfigurationImpl(this.metadatas);
    }

    Map<String, DiffMetadata> getMetadatas() {
        return this.metadatas;
    }
}

