/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonpereiradev.diffobjects.builder;

import com.github.jonpereiradev.diffobjects.DiffException;
import com.github.jonpereiradev.diffobjects.builder.DiffConfiguration;
import com.github.jonpereiradev.diffobjects.builder.DiffConfigurationImpl;
import com.github.jonpereiradev.diffobjects.builder.DiffMappingAllBuilder;
import com.github.jonpereiradev.diffobjects.builder.DiffQueryBuilder;
import com.github.jonpereiradev.diffobjects.strategy.DiffMetadata;
import java.util.Map;

class DiffQueryBuilderImpl
implements DiffQueryBuilder {
    private final DiffMetadata diffMetadata;
    private final Map<String, DiffMetadata> metadatas;
    private final DiffMappingAllBuilder diffMappingAllBuilder;

    DiffQueryBuilderImpl(String field, Map<String, DiffMetadata> metadatas, DiffMappingAllBuilder diffMappingAllBuilder) {
        this.diffMetadata = metadatas.get(field);
        if (this.diffMetadata == null) {
            throw new DiffException("No field \"" + field + "\" mapped in builder. You need to map the field before query.");
        }
        this.diffMappingAllBuilder = diffMappingAllBuilder;
        this.metadatas = metadatas;
    }

    @Override
    public DiffQueryBuilder property(String key, String value) {
        this.diffMetadata.getProperties().put(key, value);
        return this;
    }

    @Override
    public DiffMappingAllBuilder unmapping() {
        this.metadatas.remove(this.diffMetadata.getProperties().get("field"));
        return this.diffMappingAllBuilder;
    }

    @Override
    public DiffConfiguration configuration() {
        return new DiffConfigurationImpl(this.metadatas);
    }
}

