/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonpereiradev.diffobjects.builder;

import com.github.jonpereiradev.diffobjects.builder.DiffConfiguration;
import com.github.jonpereiradev.diffobjects.builder.DiffConfigurationImpl;
import com.github.jonpereiradev.diffobjects.builder.DiffMappingBuilder;
import com.github.jonpereiradev.diffobjects.builder.DiffMappingBuilderImpl;
import com.github.jonpereiradev.diffobjects.builder.DiffQueryMappingBuilder;
import com.github.jonpereiradev.diffobjects.comparator.DiffComparator;
import com.github.jonpereiradev.diffobjects.strategy.DiffMetadata;

final class DiffQueryMappingBuilderImpl<T>
implements DiffQueryMappingBuilder<T> {
    private final DiffMetadata diffMetadata;
    private final DiffMappingBuilderImpl<T> diffMappingBuilder;

    DiffQueryMappingBuilderImpl(DiffMetadata diffMetadata, DiffMappingBuilderImpl<T> diffMappingBuilder) {
        this.diffMetadata = diffMetadata;
        this.diffMappingBuilder = diffMappingBuilder;
    }

    @Override
    public DiffQueryMappingBuilder<T> property(String key, String value) {
        this.diffMetadata.getProperties().put(key, value);
        return this;
    }

    @Override
    public DiffMappingBuilder<T> unmapping() {
        this.diffMappingBuilder.getMetadatas().remove(this.diffMetadata.getProperties().get("field"));
        return this.diffMappingBuilder;
    }

    @Override
    public DiffQueryMappingBuilder<T> mapping(String field) {
        return this.diffMappingBuilder.mapping(field);
    }

    @Override
    public <F> DiffQueryMappingBuilder<T> mapping(String field, Class<F> fieldClass, DiffComparator<F> comparator) {
        return this.diffMappingBuilder.mapping(field, fieldClass, comparator);
    }

    @Override
    public DiffConfiguration configuration() {
        return new DiffConfigurationImpl(this.diffMappingBuilder.getMetadatas());
    }
}

