/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonpereiradev.diffobjects.builder;

import com.github.jonpereiradev.diffobjects.DiffException;
import com.github.jonpereiradev.diffobjects.annotation.DiffIgnore;
import com.github.jonpereiradev.diffobjects.annotation.DiffMapping;
import com.github.jonpereiradev.diffobjects.annotation.DiffMappings;
import com.github.jonpereiradev.diffobjects.annotation.DiffProperty;
import com.github.jonpereiradev.diffobjects.builder.DiffBuilder;
import com.github.jonpereiradev.diffobjects.builder.DiffConfiguration;
import com.github.jonpereiradev.diffobjects.builder.DiffConfigurationImpl;
import com.github.jonpereiradev.diffobjects.builder.DiffQueryMappingBuilder;
import com.github.jonpereiradev.diffobjects.comparator.DiffComparator;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.reflect.MethodUtils;

public final class DiffReflections {
    public static DiffConfiguration mapAnnotations(Class<?> diffClass) {
        DiffBuilder<?> builder = DiffBuilder.map(diffClass);
        if (diffClass.isAnnotationPresent(DiffMappings.class)) {
            DiffReflections.mapAllMethods(diffClass, builder);
        } else {
            DiffReflections.mapAnnotationsMethods(diffClass, builder);
        }
        return new DiffConfigurationImpl(builder.getMetadatas());
    }

    public static Method discoverGetter(Class<?> diffClass, String fieldOrMethodName) {
        Method method;
        String possibleAccessMethodName = fieldOrMethodName;
        if (!fieldOrMethodName.startsWith("get")) {
            possibleAccessMethodName = "get" + StringUtils.capitalize((String)fieldOrMethodName);
        }
        if ((method = MethodUtils.getMatchingAccessibleMethod(diffClass, (String)possibleAccessMethodName, null)) == null) {
            throw new DiffException("Method " + possibleAccessMethodName + " not found or is not public and non-args in class " + diffClass.getName());
        }
        return method;
    }

    public static <T> T invoke(Object instance, Method method) {
        if (instance == null) {
            return null;
        }
        try {
            return (T)method.invoke(instance, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw new DiffException("Method " + method.getName() + " must be public and no-args.");
        }
    }

    private static DiffConfiguration mapAllMethods(Class<?> diffClass, DiffBuilder<?> builder) {
        for (Method method : diffClass.getMethods()) {
            if (method.isAnnotationPresent(DiffIgnore.class)) continue;
            builder.mapping(method.getName());
        }
        return new DiffConfigurationImpl(builder.getMetadatas());
    }

    private static DiffConfiguration mapAnnotationsMethods(Class<?> diffClass, DiffBuilder<?> builder) {
        for (Method method : diffClass.getMethods()) {
            if (method.isAnnotationPresent(DiffMapping.class)) {
                DiffReflections.mapping(builder, method, method.getAnnotation(DiffMapping.class));
                continue;
            }
            if (!method.isAnnotationPresent(DiffMappings.class)) continue;
            for (DiffMapping diffMapping : method.getAnnotation(DiffMappings.class).value()) {
                DiffReflections.mapping(builder, method, diffMapping);
            }
        }
        return new DiffConfigurationImpl(builder.getMetadatas());
    }

    private static void mapping(DiffBuilder builder, Method method, DiffMapping diffMapping) {
        if (Collection.class.isAssignableFrom(method.getReturnType())) {
            DiffReflections.mappingCollection(builder, method, diffMapping);
        } else {
            DiffReflections.mappingField(builder, method, diffMapping);
        }
    }

    private static void mappingField(DiffBuilder builder, Method method, DiffMapping diffMapping) {
        String field = method.getName();
        DiffComparator comparator = DiffReflections.newInstance(diffMapping.comparator());
        if (!diffMapping.value().isEmpty()) {
            field = field + "." + diffMapping.value();
        }
        DiffQueryMappingBuilder query = builder.mapping(field, method.getReturnType(), comparator);
        for (DiffProperty diffProperty : diffMapping.properties()) {
            query.property(diffProperty.key(), diffProperty.value());
        }
    }

    private static void mappingCollection(DiffBuilder builder, Method method, DiffMapping diffMapping) {
        DiffComparator collection = DiffReflections.newInstance(diffMapping.collection());
        DiffComparator comparator = DiffReflections.newInstance(diffMapping.comparator());
        DiffQueryMappingBuilder collectionBuilder = builder.mapping(method.getName(), method.getReturnType(), collection);
        if (!diffMapping.value().isEmpty()) {
            collectionBuilder.mapping(method.getName() + "." + diffMapping.value(), method.getReturnType(), comparator);
        }
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new UnsupportedOperationException(e);
        }
    }
}

