/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonpereiradev.diffobjects.strategy;

import com.github.jonpereiradev.diffobjects.DiffResult;
import com.github.jonpereiradev.diffobjects.builder.DiffReflections;
import com.github.jonpereiradev.diffobjects.comparator.DiffComparator;
import com.github.jonpereiradev.diffobjects.comparator.IndexComparator;
import com.github.jonpereiradev.diffobjects.strategy.DiffMetadata;
import com.github.jonpereiradev.diffobjects.strategy.DiffStrategy;
import com.github.jonpereiradev.diffobjects.strategy.DiffStrategyType;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.stream.Stream;

final class DiffCollectionStrategy
implements DiffStrategy {
    DiffCollectionStrategy() {
    }

    @Override
    public DiffResult diff(Object before, Object after, DiffMetadata diffMetadata) {
        DiffComparator<?> comparator = diffMetadata.getComparator();
        DiffComparator<?> collection = diffMetadata.getCollectionComparator();
        Collection<?> beforeCollection = this.initializeCollection(before, diffMetadata.getMethod());
        Collection<?> afterCollection = this.initializeCollection(after, diffMetadata.getMethod());
        if (beforeCollection == null && afterCollection == null) {
            return new DiffResult(null, null, true);
        }
        if (!this.isEqualsSize(beforeCollection, afterCollection)) {
            return new DiffResult(beforeCollection, afterCollection, false);
        }
        ArrayList afterCopy = new ArrayList(afterCollection);
        Iterator<?> iterator = afterCollection.iterator();
        for (Object currentBefore : beforeCollection) {
            DiffResult single;
            Object currentAfter = this.retrieveAfterObject(collection, afterCollection, iterator, currentBefore);
            if (currentAfter == null) {
                return new DiffResult(beforeCollection, afterCollection, false);
            }
            afterCopy.remove(currentAfter);
            if (!(!diffMetadata.getValue().isEmpty() ? !(single = this.getDiffResult(diffMetadata, comparator, collection, currentBefore, currentAfter)).isEquals() : !currentBefore.equals(currentAfter))) continue;
            return new DiffResult(beforeCollection, afterCollection, false);
        }
        for (Object currentAfter : afterCopy) {
            Stream<Object> stream = beforeCollection.stream().filter(o -> collection.equals(o, currentAfter));
            Object currentBefore = stream.findFirst().orElse(null);
            if (currentBefore != null) continue;
            return new DiffResult(beforeCollection, afterCollection, false);
        }
        return new DiffResult(beforeCollection, afterCollection, true);
    }

    private Object retrieveAfterObject(DiffComparator collection, Collection<?> afterCollection, Iterator<?> iterator, Object currentBefore) {
        Object currentAfter = iterator.next();
        if (!(collection instanceof IndexComparator)) {
            Stream<Object> stream = afterCollection.stream().filter(o -> collection.equals(currentBefore, o));
            currentAfter = stream.findFirst().orElse(null);
        }
        return currentAfter;
    }

    private Collection<?> initializeCollection(Object object, Method method) {
        Collection collection = (Collection)DiffReflections.invoke(object, method);
        if (collection != null && collection.isEmpty()) {
            return null;
        }
        return collection;
    }

    private boolean isEqualsSize(Collection<?> beforeCollection, Collection<?> afterCollection) {
        return beforeCollection != null && afterCollection != null && beforeCollection.size() == afterCollection.size();
    }

    private DiffResult getDiffResult(DiffMetadata diffMetadata, DiffComparator comparator, DiffComparator collection, Object currentBefore, Object currentAfter) {
        String value = diffMetadata.getValue();
        String currentValue = value.contains(".") ? value.substring(0, value.indexOf(".")) : value;
        String nextValue = value.contains(".") ? value.substring(value.indexOf(".") + 1) : "";
        DiffStrategyType diffStrategyType = nextValue.isEmpty() ? DiffStrategyType.SINGLE : DiffStrategyType.NESTED;
        Method method = DiffReflections.discoverGetter(currentBefore.getClass(), currentValue);
        DiffMetadata metadata = new DiffMetadata(nextValue, method, diffStrategyType, comparator, collection);
        DiffStrategy strategy = metadata.getStrategy();
        return strategy.diff(currentBefore, currentAfter, metadata);
    }
}

