/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonpereiradev.diffobjects.strategy;

import com.github.jonpereiradev.diffobjects.DiffResult;
import com.github.jonpereiradev.diffobjects.builder.DiffReflections;
import com.github.jonpereiradev.diffobjects.comparator.DiffComparator;
import com.github.jonpereiradev.diffobjects.strategy.DiffMetadata;
import com.github.jonpereiradev.diffobjects.strategy.DiffStrategy;
import java.lang.reflect.Method;

final class DiffNestedStrategy
implements DiffStrategy {
    private static final String REGEX_PROPERTY_SEPARATOR = "\\.";

    DiffNestedStrategy() {
    }

    @Override
    public DiffResult diff(Object before, Object after, DiffMetadata diffMetadata) {
        DiffComparator<?> comparator = diffMetadata.getComparator();
        Method beforeMethod = diffMetadata.getMethod();
        Method afterMethod = diffMetadata.getMethod();
        Object beforeObject = DiffReflections.invoke(before, beforeMethod);
        Object afterObject = DiffReflections.invoke(after, afterMethod);
        if (beforeObject != null || afterObject != null) {
            for (String property : diffMetadata.getValue().split(REGEX_PROPERTY_SEPARATOR)) {
                if (beforeObject != null) {
                    beforeMethod = DiffReflections.discoverGetter(beforeObject.getClass(), property);
                    beforeObject = DiffReflections.invoke(beforeObject, beforeMethod);
                }
                if (afterObject == null) continue;
                afterMethod = DiffReflections.discoverGetter(afterObject.getClass(), property);
                afterObject = DiffReflections.invoke(afterObject, afterMethod);
            }
        }
        return new DiffResult(beforeObject, afterObject, comparator.equals(beforeObject, afterObject));
    }
}

