/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonpereiradev.diffobjects;

import com.github.jonpereiradev.diffobjects.DiffResult;
import com.github.jonpereiradev.diffobjects.builder.DiffConfiguration;
import com.github.jonpereiradev.diffobjects.builder.DiffReflections;
import com.github.jonpereiradev.diffobjects.comparator.DiffComparator;
import com.github.jonpereiradev.diffobjects.strategy.DiffMetadata;
import com.github.jonpereiradev.diffobjects.strategy.DiffStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public final class DiffObjects<T> {
    private final DiffConfiguration annotations;

    private DiffObjects(Class<T> clazz) {
        this.annotations = DiffReflections.mapAnnotations(clazz);
    }

    public static <T> DiffObjects<T> forClass(Class<T> clazz) {
        return new DiffObjects<T>(clazz);
    }

    public List<DiffResult> diff(T expected, T current) {
        Objects.requireNonNull(expected, "Expected state is required.");
        Objects.requireNonNull(current, "Current state is required.");
        return this.diff(expected, current, this.annotations);
    }

    public List<DiffResult> diff(T expected, T current, DiffConfiguration configuration) {
        Objects.requireNonNull(expected, "Expected state is required.");
        Objects.requireNonNull(current, "Current state is required.");
        Objects.requireNonNull(configuration, "Configuration is required.");
        List<DiffMetadata> metadatas = configuration.build();
        ArrayList<DiffResult> results = new ArrayList<DiffResult>(metadatas.size());
        for (DiffMetadata metadata : metadatas) {
            DiffStrategy strategy = metadata.getStrategy();
            DiffResult diff = strategy.diff(expected, current, metadata);
            diff.setProperties(Collections.unmodifiableMap(metadata.getProperties()));
            results.add(diff);
        }
        return results;
    }

    public List<DiffResult> diff(Collection<T> expected, Collection<T> current, DiffComparator<T> matcher) {
        Objects.requireNonNull(expected, "Expected state is required.");
        Objects.requireNonNull(current, "Current state is required.");
        return this.diff(expected, current, this.annotations, matcher);
    }

    public List<DiffResult> diff(Collection<T> expectedCollection, Collection<T> currentCollection, DiffConfiguration configuration, DiffComparator<T> matcher) {
        Stream<Object> stream;
        Objects.requireNonNull(expectedCollection, "Before state is required.");
        Objects.requireNonNull(currentCollection, "After state is required.");
        Objects.requireNonNull(configuration, "Configuration is required.");
        ArrayList<DiffResult> results = new ArrayList<DiffResult>();
        for (Object expected2 : expectedCollection) {
            stream = currentCollection.stream().filter(current -> matcher.isEquals(expected2, current));
            Object after = stream.findFirst().orElse(null);
            if (after == null) {
                results.add(new DiffResult(expected2, null, false));
                continue;
            }
            boolean equals = true;
            for (DiffMetadata metadata : configuration.build()) {
                DiffStrategy strategy = metadata.getStrategy();
                DiffResult diff = strategy.diff(expected2, after, metadata);
                if (diff.isEquals()) continue;
                equals = false;
                break;
            }
            results.add(new DiffResult(expected2, after, equals));
        }
        for (Object current2 : currentCollection) {
            stream = expectedCollection.stream().filter(expected -> matcher.isEquals(current2, expected));
            Object expected3 = stream.findFirst().orElse(null);
            if (expected3 != null) continue;
            results.add(new DiffResult(null, current2, false));
        }
        return results;
    }

    public boolean isEquals(T expected, T current) {
        Objects.requireNonNull(expected, "Expected state is required.");
        Objects.requireNonNull(current, "Current state is required.");
        return this.isEquals(expected, current, this.annotations);
    }

    public boolean isEquals(T expected, T current, DiffConfiguration configuration) {
        Objects.requireNonNull(expected, "Before state is required.");
        Objects.requireNonNull(current, "After state is required.");
        Objects.requireNonNull(configuration, "Configuration is required.");
        for (DiffMetadata metadata : configuration.build()) {
            DiffStrategy strategy = metadata.getStrategy();
            DiffResult result = strategy.diff(expected, current, metadata);
            if (result.isEquals()) continue;
            return false;
        }
        return true;
    }

    public boolean isEquals(Collection<T> expectedCollection, Collection<T> currentCollection, DiffComparator<T> matcher) {
        Objects.requireNonNull(expectedCollection, "Expected Collection state is required.");
        Objects.requireNonNull(currentCollection, "Current Collection state is required.");
        return this.isEquals(expectedCollection, currentCollection, this.annotations, matcher);
    }

    public boolean isEquals(Collection<T> expectedCollection, Collection<T> currentCollection, DiffConfiguration configuration, DiffComparator<T> matcher) {
        Stream<Object> stream;
        Objects.requireNonNull(expectedCollection, "Before state is required.");
        Objects.requireNonNull(currentCollection, "After state is required.");
        Objects.requireNonNull(configuration, "Configuration is required.");
        ArrayList<T> currentCollectionCopy = new ArrayList<T>(currentCollection);
        for (Object expected2 : expectedCollection) {
            stream = currentCollection.stream().filter(current -> matcher.isEquals(expected2, current));
            T current2 = stream.findFirst().orElse(null);
            if (current2 == null) {
                return false;
            }
            currentCollectionCopy.remove(current2);
            if (this.isEquals(expected2, current2, configuration)) continue;
            return false;
        }
        for (Object current3 : currentCollectionCopy) {
            stream = expectedCollection.stream().filter(expected -> matcher.isEquals(current3, expected));
            Object expected3 = stream.findFirst().orElse(null);
            if (expected3 != null) continue;
            return false;
        }
        return true;
    }
}

