/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonpereiradev.diffobjects.builder;

import com.github.jonpereiradev.diffobjects.builder.DiffConfiguration;
import com.github.jonpereiradev.diffobjects.builder.DiffConfigurationImpl;
import com.github.jonpereiradev.diffobjects.builder.DiffMappingBuilder;
import com.github.jonpereiradev.diffobjects.builder.DiffQueryMappingBuilder;
import com.github.jonpereiradev.diffobjects.builder.DiffQueryMappingBuilderImpl;
import com.github.jonpereiradev.diffobjects.builder.DiffReflections;
import com.github.jonpereiradev.diffobjects.comparator.DiffComparator;
import com.github.jonpereiradev.diffobjects.comparator.EqualsComparator;
import com.github.jonpereiradev.diffobjects.comparator.IndexComparator;
import com.github.jonpereiradev.diffobjects.strategy.DiffMetadata;
import com.github.jonpereiradev.diffobjects.strategy.DiffStrategyType;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;

final class DiffMappingBuilderImpl<T>
implements DiffMappingBuilder<T> {
    private static final String REGEX_PROPERTY_SEPARATOR = "\\.";
    private final Class<T> classMap;
    private final Map<String, DiffMetadata> metadatas;

    DiffMappingBuilderImpl(Class<T> classMap, Map<String, DiffMetadata> metadatas) {
        this.classMap = classMap;
        this.metadatas = metadatas;
    }

    @Override
    public DiffQueryMappingBuilder<T> mapping(String field) {
        String[] fields = field.split(REGEX_PROPERTY_SEPARATOR);
        Method method = DiffReflections.discoverGetter(this.classMap, fields[0]);
        if (Collection.class.isAssignableFrom(method.getReturnType()) && fields.length == 1) {
            return this.mapping(field, new IndexComparator());
        }
        return this.mapping(field, new EqualsComparator());
    }

    @Override
    public <F> DiffQueryMappingBuilder<T> mapping(String field, DiffComparator<F> fieldComparator) {
        boolean isCollectionType;
        Objects.requireNonNull(field, "Field name is required.");
        String nestedFields = "";
        String[] fields = field.split(REGEX_PROPERTY_SEPARATOR);
        Method method = DiffReflections.discoverGetter(this.classMap, fields[0]);
        DiffStrategyType diffStrategyType = DiffStrategyType.SINGLE;
        if (fields.length > 1) {
            diffStrategyType = DiffStrategyType.NESTED;
            nestedFields = field.substring(field.indexOf(".") + 1);
        }
        if (isCollectionType = Collection.class.isAssignableFrom(method.getReturnType())) {
            diffStrategyType = DiffStrategyType.COLLECTION;
        }
        DiffMetadata diffMetadata = new DiffMetadata(nestedFields, method, diffStrategyType, fieldComparator);
        diffMetadata.getProperties().put("field", field);
        if (isCollectionType && !nestedFields.isEmpty()) {
            this.metadatas.remove(fields[0]);
        }
        this.metadatas.put(field, diffMetadata);
        return new DiffQueryMappingBuilderImpl(diffMetadata, this);
    }

    @Override
    public DiffConfiguration configuration() {
        return new DiffConfigurationImpl(this.metadatas);
    }

    Map<String, DiffMetadata> getMetadatas() {
        return this.metadatas;
    }
}

