/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonpereiradev.diffobjects.strategy;

import com.github.jonpereiradev.diffobjects.DiffResult;
import com.github.jonpereiradev.diffobjects.builder.DiffReflections;
import com.github.jonpereiradev.diffobjects.comparator.DiffComparator;
import com.github.jonpereiradev.diffobjects.strategy.DiffMetadata;
import com.github.jonpereiradev.diffobjects.strategy.DiffStrategy;
import com.github.jonpereiradev.diffobjects.strategy.DiffStrategyType;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

final class DiffCollectionStrategy
implements DiffStrategy {
    DiffCollectionStrategy() {
    }

    @Override
    public DiffResult diff(Object expected, Object current, DiffMetadata metadata) {
        DiffComparator<?> fieldComparator = metadata.getComparator();
        Collection<?> beforeCollection = this.initializeCollection(expected, metadata.getMethod());
        Collection<?> afterCollection = this.initializeCollection(current, metadata.getMethod());
        if (beforeCollection == null && afterCollection == null) {
            return new DiffResult(null, null, true);
        }
        if (!this.isEqualsSize(beforeCollection, afterCollection)) {
            return new DiffResult(beforeCollection, afterCollection, false);
        }
        ArrayList afterCopy = new ArrayList(afterCollection);
        Iterator<?> iterator = afterCollection.iterator();
        for (Object currentBefore : beforeCollection) {
            DiffResult single;
            Object currentAfter = iterator.next();
            if (currentAfter == null) {
                return new DiffResult(beforeCollection, afterCollection, false);
            }
            afterCopy.remove(currentAfter);
            if (!(!metadata.getValue().isEmpty() ? !(single = this.checkDiff(metadata, fieldComparator, currentBefore, currentAfter)).isEquals() : !fieldComparator.isEquals(currentBefore, currentAfter))) continue;
            return new DiffResult(beforeCollection, afterCollection, false);
        }
        for (Object currentAfter : afterCopy) {
            boolean noneMatch = beforeCollection.stream().noneMatch(o -> fieldComparator.isEquals(o, currentAfter));
            if (!noneMatch) continue;
            return new DiffResult(beforeCollection, afterCollection, false);
        }
        return new DiffResult(beforeCollection, afterCollection, true);
    }

    private Collection<?> initializeCollection(Object object, Method method) {
        Collection collection = (Collection)DiffReflections.invoke(object, method);
        if (collection != null && collection.isEmpty()) {
            return null;
        }
        return collection;
    }

    private boolean isEqualsSize(Collection<?> beforeCollection, Collection<?> afterCollection) {
        return beforeCollection != null && afterCollection != null && beforeCollection.size() == afterCollection.size();
    }

    private DiffResult checkDiff(DiffMetadata diffMetadata, DiffComparator fieldComparator, Object currentBefore, Object currentAfter) {
        String value = diffMetadata.getValue();
        String currentValue = value.contains(".") ? value.substring(0, value.indexOf(".")) : value;
        String nextValue = value.contains(".") ? value.substring(value.indexOf(".") + 1) : "";
        DiffStrategyType diffStrategyType = nextValue.isEmpty() ? DiffStrategyType.SINGLE : DiffStrategyType.NESTED;
        Method method = DiffReflections.discoverGetter(currentBefore.getClass(), currentValue);
        DiffMetadata metadata = new DiffMetadata(nextValue, method, diffStrategyType, fieldComparator);
        DiffStrategy strategy = metadata.getStrategy();
        return strategy.diff(currentBefore, currentAfter, metadata);
    }
}

