/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonpereiradev.diffobjects.strategy;

import com.github.jonpereiradev.diffobjects.comparator.DiffComparator;
import com.github.jonpereiradev.diffobjects.strategy.DiffStrategy;
import com.github.jonpereiradev.diffobjects.strategy.DiffStrategyType;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public final class DiffMetadata
implements Comparable<DiffMetadata> {
    private static final DiffStrategy DEFAULT_STRATEGY = DiffStrategyType.SINGLE.getStrategy();
    private final String value;
    private final Method method;
    private final DiffStrategy strategy;
    private final DiffComparator<?> comparator;
    private final Map<String, String> properties;
    private int order;

    public DiffMetadata(String value, Method method, DiffStrategyType diffStrategyType, DiffComparator<?> comparator) {
        this.value = StringUtils.trimToEmpty((String)value);
        this.method = Objects.requireNonNull(method);
        this.strategy = diffStrategyType == null ? DEFAULT_STRATEGY : diffStrategyType.getStrategy();
        this.comparator = Objects.requireNonNull(comparator);
        this.properties = new HashMap<String, String>();
    }

    @Override
    public int compareTo(DiffMetadata o) {
        return Integer.compare(this.order, o.order);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiffMetadata that = (DiffMetadata)o;
        return Objects.equals(this.method, that.method);
    }

    public int hashCode() {
        return Objects.hash(this.method);
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public String getValue() {
        return this.value;
    }

    public Method getMethod() {
        return this.method;
    }

    public DiffStrategy getStrategy() {
        return this.strategy;
    }

    public DiffComparator<?> getComparator() {
        return this.comparator;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }
}

