/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonpereiradev.diffobjects.strategy;

import com.github.jonpereiradev.diffobjects.DiffResult;
import com.github.jonpereiradev.diffobjects.builder.DiffReflections;
import com.github.jonpereiradev.diffobjects.comparator.DiffComparator;
import com.github.jonpereiradev.diffobjects.strategy.DiffMetadata;
import com.github.jonpereiradev.diffobjects.strategy.DiffStrategy;
import java.lang.reflect.Method;

final class DiffNestedStrategy
implements DiffStrategy {
    private static final String REGEX_PROPERTY_SEPARATOR = "\\.";

    DiffNestedStrategy() {
    }

    @Override
    public DiffResult diff(Object expected, Object current, DiffMetadata metadata) {
        DiffComparator<?> comparator = metadata.getComparator();
        Method expectedMethod = metadata.getMethod();
        Method currentMethod = metadata.getMethod();
        Object expectedObject = DiffReflections.invoke(expected, expectedMethod);
        Object currentObject = DiffReflections.invoke(current, currentMethod);
        if (expectedObject != null || currentObject != null) {
            for (String property : metadata.getValue().split(REGEX_PROPERTY_SEPARATOR)) {
                if (expectedObject != null) {
                    expectedMethod = DiffReflections.discoverGetter(expectedObject.getClass(), property);
                    expectedObject = DiffReflections.invoke(expectedObject, expectedMethod);
                }
                if (currentObject == null) continue;
                currentMethod = DiffReflections.discoverGetter(currentObject.getClass(), property);
                currentObject = DiffReflections.invoke(currentObject, currentMethod);
            }
        }
        return new DiffResult(expectedObject, currentObject, comparator.isEquals(expectedObject, currentObject));
    }
}

