/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.clerezza;

import com.github.jsonldjava.clerezza.ClerezzaTripleCallback;
import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.JsonLdProcessor;
import com.github.jsonldjava.core.JsonLdTripleCallback;
import com.github.jsonldjava.utils.JsonUtils;
import java.io.IOException;
import java.io.InputStream;
import org.apache.clerezza.commons.rdf.Graph;
import org.apache.clerezza.commons.rdf.IRI;
import org.apache.clerezza.rdf.core.serializedform.ParsingProvider;
import org.apache.clerezza.rdf.core.serializedform.SupportedFormat;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SupportedFormat(value={"application/ld+json"})
@Component(immediate=true, policy=ConfigurationPolicy.OPTIONAL)
@Service
public class ClerezzaJsonLdParsingProvider
implements ParsingProvider {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void parse(Graph target, InputStream serializedGraph, String formatIdentifier, IRI baseUri) {
        Object input;
        ClerezzaTripleCallback ctc = new ClerezzaTripleCallback();
        ctc.setMGraph(target);
        int startSize = 0;
        if (this.logger.isDebugEnabled()) {
            startSize = target.size();
        }
        long start = System.currentTimeMillis();
        try {
            input = JsonUtils.fromInputStream((InputStream)serializedGraph, (String)"UTF-8");
        }
        catch (IOException e) {
            this.logger.error("Unable to read from the parsed input stream", (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        try {
            JsonLdProcessor.toRDF((Object)input, (JsonLdTripleCallback)ctc);
        }
        catch (JsonLdError e) {
            this.logger.error("Unable to parse JSON-LD from the parsed input stream", (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" - parsed {} triples in {}ms", (Object)(target.size() - startSize), (Object)(System.currentTimeMillis() - start));
        }
    }
}

