/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.clerezza;

import com.github.jsonldjava.core.JsonLdTripleCallback;
import com.github.jsonldjava.core.RDFDataset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.clerezza.rdf.core.BNode;
import org.apache.clerezza.rdf.core.Language;
import org.apache.clerezza.rdf.core.MGraph;
import org.apache.clerezza.rdf.core.NonLiteral;
import org.apache.clerezza.rdf.core.Resource;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.core.impl.PlainLiteralImpl;
import org.apache.clerezza.rdf.core.impl.SimpleMGraph;
import org.apache.clerezza.rdf.core.impl.TripleImpl;
import org.apache.clerezza.rdf.core.impl.TypedLiteralImpl;

public class ClerezzaTripleCallback
implements JsonLdTripleCallback {
    private static final String RDF_LANG_STRING = "http://www.w3.org/1999/02/22-rdf-syntax-ns#langString";
    private MGraph mGraph = new SimpleMGraph();
    private Map<String, BNode> bNodeMap = new HashMap<String, BNode>();

    public void setMGraph(MGraph mGraph) {
        this.mGraph = mGraph;
        this.bNodeMap = new HashMap<String, BNode>();
    }

    public MGraph getMGraph() {
        return this.mGraph;
    }

    private void triple(String s, String p, String o, String graph) {
        if (s == null || p == null || o == null) {
            return;
        }
        NonLiteral subject = this.getNonLiteral(s);
        UriRef predicate = new UriRef(p);
        NonLiteral object = this.getNonLiteral(o);
        this.mGraph.add((Object)new TripleImpl(subject, predicate, (Resource)object));
    }

    private void triple(String s, String p, String value, String datatype, String language, String graph) {
        NonLiteral subject = this.getNonLiteral(s);
        UriRef predicate = new UriRef(p);
        Object object = language != null ? new PlainLiteralImpl(value, new Language(language)) : (datatype == null || RDF_LANG_STRING.equals(datatype) ? new PlainLiteralImpl(value) : new TypedLiteralImpl(value, new UriRef(datatype)));
        this.mGraph.add((Object)new TripleImpl(subject, predicate, (Resource)object));
    }

    private NonLiteral getNonLiteral(String s) {
        if (s.startsWith("_:")) {
            return this.getBNode(s);
        }
        return new UriRef(s);
    }

    private BNode getBNode(String s) {
        if (this.bNodeMap.containsKey(s)) {
            return this.bNodeMap.get(s);
        }
        BNode result = new BNode();
        this.bNodeMap.put(s, result);
        return result;
    }

    public Object call(RDFDataset dataset) {
        for (String graphName : dataset.graphNames()) {
            List quads = dataset.getQuads(graphName);
            if ("@default".equals(graphName)) {
                graphName = null;
            }
            for (RDFDataset.Quad quad : quads) {
                if (quad.getObject().isLiteral()) {
                    this.triple(quad.getSubject().getValue(), quad.getPredicate().getValue(), quad.getObject().getValue(), quad.getObject().getDatatype(), quad.getObject().getLanguage(), graphName);
                    continue;
                }
                this.triple(quad.getSubject().getValue(), quad.getPredicate().getValue(), quad.getObject().getValue(), graphName);
            }
        }
        return this.getMGraph();
    }
}

