/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.jena;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.github.jsonldjava.core.JSONLDTripleCallback;
import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.JsonLdProcessor;
import com.github.jsonldjava.jena.JenaTripleCallback;
import com.github.jsonldjava.utils.Obj;
import com.hp.hpl.jena.rdf.model.Model;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class JenaTripleCallbackTest {
    @Test
    public void triplesTest() throws JsonParseException, JsonMappingException, JsonLdError {
        ArrayList<Map<String, Object>> input = new ArrayList<Map<String, Object>>(){
            {
                this.add(new LinkedHashMap<String, Object>(){
                    {
                        this.put("@id", "http://localhost:8080/foo1");
                        this.put("http://foo.com/code", new ArrayList<Object>(){
                            {
                                this.add(new LinkedHashMap<String, Object>(){
                                    {
                                        this.put("@value", "123");
                                    }
                                });
                            }
                        });
                    }
                });
                this.add(new LinkedHashMap<String, Object>(){
                    {
                        this.put("@id", "http://localhost:8080/foo2");
                        this.put("http://foo.com/code", new ArrayList<Object>(){
                            {
                                this.add(new LinkedHashMap<String, Object>(){
                                    {
                                        this.put("@value", "ABC");
                                    }
                                });
                            }
                        });
                    }
                });
            }
        };
        ArrayList<String> expected = new ArrayList<String>(){
            {
                this.add("<http://localhost:8080/foo1> <http://foo.com/code> \"123\"^^<http://www.w3.org/2001/XMLSchema#string> .");
                this.add("<http://localhost:8080/foo2> <http://foo.com/code> \"ABC\"^^<http://www.w3.org/2001/XMLSchema#string> .");
            }
        };
        JenaTripleCallback callback = new JenaTripleCallback();
        Model model = (Model)JsonLdProcessor.toRDF((Object)input, (JSONLDTripleCallback)callback);
        StringWriter w = new StringWriter();
        model.write((Writer)w, "N-TRIPLE");
        ArrayList<String> result = new ArrayList<String>(Arrays.asList(w.getBuffer().toString().split("\n")));
        Collections.sort(result);
        Assert.assertTrue((boolean)Obj.equals((Object)expected, result));
    }
}

