/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.impl;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.github.jsonldjava.core.JSONLD;
import com.github.jsonldjava.core.JSONLDProcessingError;
import com.github.jsonldjava.core.JSONLDTripleCallback;
import com.github.jsonldjava.impl.SesameTripleCallback;
import com.github.jsonldjava.utils.JSONUtils;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.openrdf.model.Statement;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.LinkedHashModel;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.rio.ParseErrorListener;
import org.openrdf.rio.ParserConfig;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.helpers.ParseErrorCollector;
import org.openrdf.rio.helpers.StatementCollector;

public class SesameTripleCallbackTest {
    @Test
    public void triplesTest() throws JsonParseException, JsonMappingException, JSONLDProcessingError {
        String inputstring = "{ \"@id\":\"http://nonexistent.com/abox#Document1823812\", \"@type\":\"http://nonexistent.com/tbox#Document\" }";
        String expectedString = "(http://nonexistent.com/abox#Document1823812, http://www.w3.org/1999/02/22-rdf-syntax-ns#type, http://nonexistent.com/tbox#Document) [null]";
        Object input = JSONUtils.fromString((String)inputstring);
        LinkedHashModel graph = new LinkedHashModel();
        ParseErrorCollector parseErrorListener = new ParseErrorCollector();
        ParserConfig parserConfig = new ParserConfig();
        SesameTripleCallback callback = new SesameTripleCallback((RDFHandler)new StatementCollector((Collection)graph), (ValueFactory)ValueFactoryImpl.getInstance(), parserConfig, (ParseErrorListener)parseErrorListener);
        JSONLD.toRDF((Object)input, (JSONLDTripleCallback)callback);
        for (Statement stmt : graph) {
            System.out.println(stmt.toString());
            Assert.assertEquals((String)"Output was not as expected", (Object)stmt.toString(), (Object)expectedString);
        }
        Assert.assertEquals((long)0L, (long)parseErrorListener.getFatalErrors().size());
        Assert.assertEquals((long)0L, (long)parseErrorListener.getErrors().size());
        Assert.assertEquals((long)0L, (long)parseErrorListener.getWarnings().size());
    }
}

