/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.tools;

import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.RDFDataset;
import com.github.jsonldjava.core.RDFParser;
import java.util.Optional;
import java.util.Set;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;

class RDF4JJSONLDRDFParser
implements RDFParser {
    RDF4JJSONLDRDFParser() {
    }

    public void setPrefix(RDFDataset result, String fullUri, String prefix) {
        result.setNamespace(fullUri, prefix);
    }

    public void handleStatement(RDFDataset result, Statement nextStatement) {
        String subject = this.getResourceValue(nextStatement.getSubject());
        String predicate = this.getResourceValue((Resource)nextStatement.getPredicate());
        Value object = nextStatement.getObject();
        String graphName = this.getResourceValue(nextStatement.getContext());
        if (object instanceof Literal) {
            Literal literal = (Literal)object;
            String value = literal.getLabel();
            Optional language = literal.getLanguage();
            String datatype = this.getResourceValue((Resource)literal.getDatatype());
            if (language.isPresent() && datatype == null) {
                datatype = RDF.LANGSTRING.stringValue();
            }
            if (!language.isPresent() && datatype == null) {
                datatype = XMLSchema.STRING.stringValue();
            }
            result.addQuad(subject, predicate, value, datatype, (String)language.orElse(null), graphName);
        } else {
            result.addQuad(subject, predicate, this.getResourceValue((Resource)object), graphName);
        }
    }

    private String getResourceValue(Resource subject) {
        if (subject == null) {
            return null;
        }
        if (subject instanceof IRI) {
            return subject.stringValue();
        }
        if (subject instanceof BNode) {
            return "_:" + subject.stringValue();
        }
        throw new IllegalStateException("Did not recognise resource type: " + subject.getClass().getName());
    }

    public RDFDataset parse(Object input) throws JsonLdError {
        RDFDataset result = new RDFDataset();
        if (input instanceof Statement) {
            this.handleStatement(result, (Statement)input);
        } else if (input instanceof Model) {
            Set namespaces = ((Model)input).getNamespaces();
            for (Namespace nextNs : namespaces) {
                result.setNamespace(nextNs.getName(), nextNs.getPrefix());
            }
            for (Statement nextStatement : (Model)input) {
                this.handleStatement(result, nextStatement);
            }
        }
        return result;
    }
}

