package com.github.kancyframework.validationplus.validator;

import com.github.kancyframework.validationplus.constraints.AreaCode;
import java.util.regex.Pattern;

/**
 * 行政区划验证器
 */
public class AreaCodeConstraintValidator extends CheckEmptyConstraintValidator<AreaCode, Object> {

    /**
     * 验证的值不为空时，验证结果
     *
     * @param value
     * @return
     */
    @Override
    protected boolean check(Object value) {
        return Pattern.compile(annotation.regexp()).matcher(String.valueOf(value)).find();
    }

    /**
     * 验证的值为空时，返回结果
     *
     * @return
     */
    @Override
    protected boolean requestEmptyResult() {
        return !annotation.required();
    }
}
