package com.github.kancyframework.validationplus.validator;

import com.github.kancyframework.validationplus.constraints.BankCard;

import java.util.regex.Pattern;

/**
 * <p>
 * 银行卡号验证器
 * <p>
 *
 * @author: kancy
 * @date: 2020/4/20 11:08
 **/

public class BankCardConstraintValidator extends CheckEmptyConstraintValidator<BankCard, Object>{
    /**
     * 验证的值不为空时，验证结果
     *
     * @param value
     * @return
     */
    @Override
    protected boolean check(Object value) {
        return Pattern.compile(annotation.regexp()).matcher(String.valueOf(value)).find();
    }

    /**
     * 验证的值为空时，返回结果
     *
     * @return
     */
    @Override
    protected boolean requestEmptyResult() {
        return !annotation.required();
    }
}
