/*
 * Decompiled with CFR 0.152.
 */
package com.github.kayjamlang.executor;

import com.github.kayjamlang.core.Expression;
import com.github.kayjamlang.core.containers.Container;
import com.github.kayjamlang.core.containers.Function;
import com.github.kayjamlang.executor.TypeUtils;
import com.github.kayjamlang.executor.exceptions.KayJamNotFoundException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Context {
    public final Container parent;
    public final Context parentContext;
    public final boolean useParentVars;
    public final Map<String, Object> variables = new HashMap<String, Object>();

    public Context(Container parent, Context parentContext, boolean useParentVars) {
        this.parent = parent;
        this.parentContext = parentContext;
        this.useParentVars = useParentVars;
        if (parentContext != null && useParentVars) {
            this.variables.putAll(parentContext.variables);
        }
    }

    public Context(Container parent, Context parentContext) {
        this(parent, parentContext, true);
    }

    public Function findFunction(Expression expression, String name, List<Object> args) throws KayJamNotFoundException {
        for (Function function : this.parent.functions) {
            if (!function.name.equals(name) || function.arguments.size() != args.size() || !TypeUtils.isAccept(function.arguments, args)) continue;
            return function;
        }
        if (this.parentContext != null) {
            return this.parentContext.findFunction(expression, name, args);
        }
        throw new KayJamNotFoundException(expression, "function", name);
    }

    public boolean setVariable(String name, Object value) {
        if (this.variables.containsKey(name)) {
            this.variables.put(name, value);
            return true;
        }
        if (this.useParentVars && this.parentContext != null && this.parentContext.variables.containsKey(name)) {
            this.variables.put(name, value);
            return this.parentContext.setVariable(name, value);
        }
        return false;
    }
}

