/*
 * Decompiled with CFR 0.152.
 */
package com.github.kayjamlang.executor;

import com.github.kayjamlang.core.Expression;
import com.github.kayjamlang.core.KayJamLexer;
import com.github.kayjamlang.core.KayJamParser;
import com.github.kayjamlang.core.containers.ClassContainer;
import com.github.kayjamlang.core.containers.ConstructorContainer;
import com.github.kayjamlang.core.containers.Container;
import com.github.kayjamlang.core.containers.Function;
import com.github.kayjamlang.core.containers.ObjectContainer;
import com.github.kayjamlang.core.expressions.Access;
import com.github.kayjamlang.core.expressions.Array;
import com.github.kayjamlang.core.expressions.CallCreate;
import com.github.kayjamlang.core.expressions.CompanionAccess;
import com.github.kayjamlang.core.expressions.Const;
import com.github.kayjamlang.core.expressions.ForExpression;
import com.github.kayjamlang.core.expressions.If;
import com.github.kayjamlang.core.expressions.OperationExpression;
import com.github.kayjamlang.core.expressions.Return;
import com.github.kayjamlang.core.expressions.Use;
import com.github.kayjamlang.core.expressions.Variable;
import com.github.kayjamlang.core.expressions.VariableLink;
import com.github.kayjamlang.core.expressions.VariableSet;
import com.github.kayjamlang.core.expressions.WhileExpression;
import com.github.kayjamlang.core.provider.MainExpressionProvider;
import com.github.kayjamlang.executor.Context;
import com.github.kayjamlang.executor.MainContext;
import com.github.kayjamlang.executor.exceptions.KayJamNotFoundException;
import com.github.kayjamlang.executor.exceptions.KayJamRuntimeException;
import com.github.kayjamlang.executor.executors.AccessExecutor;
import com.github.kayjamlang.executor.executors.ArrayExecutor;
import com.github.kayjamlang.executor.executors.CallCreateExecutor;
import com.github.kayjamlang.executor.executors.ClassContainerExecutor;
import com.github.kayjamlang.executor.executors.CodeExecExpressionExecutor;
import com.github.kayjamlang.executor.executors.CompanionAccessExecutor;
import com.github.kayjamlang.executor.executors.ConstExecutor;
import com.github.kayjamlang.executor.executors.ContainerExecutor;
import com.github.kayjamlang.executor.executors.ForExpressionExecutor;
import com.github.kayjamlang.executor.executors.IfExecutor;
import com.github.kayjamlang.executor.executors.ObjectExecutor;
import com.github.kayjamlang.executor.executors.OperationExpressionExecutor;
import com.github.kayjamlang.executor.executors.ReturnExecutor;
import com.github.kayjamlang.executor.executors.VariableExecutor;
import com.github.kayjamlang.executor.executors.VariableLinkExecutor;
import com.github.kayjamlang.executor.executors.VariableSetExecutor;
import com.github.kayjamlang.executor.executors.WhileExpressionExecutor;
import com.github.kayjamlang.executor.libs.Library;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Executor
extends MainExpressionProvider<Object, Context, MainContext> {
    private final List<Library> libraries = new ArrayList<Library>();
    private UseGetFile useGetFileListener;

    public Executor() {
        super(null);
        this.addCompiler(Container.class, new ContainerExecutor());
        this.addCompiler(ObjectContainer.class, new ObjectExecutor());
        this.addCompiler(ClassContainer.class, new ClassContainerExecutor());
        this.addCompiler(Variable.class, new VariableExecutor());
        this.addCompiler(VariableLink.class, new VariableLinkExecutor());
        this.addCompiler(VariableSet.class, new VariableSetExecutor());
        this.addCompiler(Library.CodeExecExpression.class, new CodeExecExpressionExecutor());
        this.addCompiler(Access.class, new AccessExecutor());
        this.addCompiler(CompanionAccess.class, new CompanionAccessExecutor());
        this.addCompiler(Const.class, new ConstExecutor());
        this.addCompiler(Array.class, new ArrayExecutor());
        this.addCompiler(Return.class, new ReturnExecutor());
        this.addCompiler(If.class, new IfExecutor());
        this.addCompiler(CallCreate.class, new CallCreateExecutor());
        this.addCompiler(OperationExpression.class, new OperationExpressionExecutor());
        this.addCompiler(WhileExpression.class, new WhileExpressionExecutor());
        this.addCompiler(ForExpression.class, new ForExpressionExecutor());
    }

    public void addLibrary(Library library) {
        this.libraries.add(library);
    }

    public Object execute(String code) throws Exception {
        if (!code.startsWith("{") || !code.endsWith("}")) {
            code = "{" + code + "}";
        }
        KayJamParser parser = new KayJamParser(new KayJamLexer(code));
        return this.execute((Container)parser.readExpression());
    }

    public Object executeWithOldContext(String code) throws Exception {
        if (!code.startsWith("{") || !code.endsWith("}")) {
            code = "{" + code + "}";
        }
        KayJamParser parser = new KayJamParser(new KayJamLexer(code));
        return this.executeWithOldContext((Container)parser.readExpression());
    }

    public Object execute(Container container) throws Exception {
        this.mainContext = new MainContext(container, null);
        for (Library library : this.libraries) {
            ((MainContext)this.mainContext).classes.putAll(library.classes);
            container.functions.addAll(library.functions);
        }
        return this.executeWithOldContext(container);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object executeWithOldContext(Container container) throws Exception {
        ClassContainer classContainer;
        boolean useEnded = false;
        for (Expression expression : container.children) {
            if (expression instanceof Use) {
                if (useEnded) throw new KayJamRuntimeException(expression, "The use statements must be at the beginning of the file");
                if (this.useGetFileListener == null) {
                    throw new KayJamRuntimeException(expression, "Use expression unsupported");
                }
                Use use = (Use)expression;
                Executor executor = this.handleUse((Expression)use);
                if (executor.mainContext == null) {
                    throw new KayJamRuntimeException(expression, "Unknown error");
                }
                ((MainContext)this.mainContext).classes.putAll(((MainContext)executor.mainContext).classes);
            } else if (!useEnded) {
                useEnded = true;
            }
            if (!(expression instanceof ClassContainer)) continue;
            classContainer = (ClassContainer)expression;
            if (((MainContext)this.mainContext).classes.containsKey(classContainer.name)) {
                throw new KayJamRuntimeException((Expression)classContainer, "A class with the same name has already been declared");
            }
            for (Expression classExpression : classContainer.children) {
                if (classExpression.getClass().equals(Variable.class) || classExpression instanceof ConstructorContainer) continue;
                throw new KayJamRuntimeException(classExpression, "The class can only contain variables and functions");
            }
            ((MainContext)this.mainContext).classes.put(classContainer.name, classContainer);
        }
        for (Map.Entry entry : ((MainContext)this.mainContext).classes.entrySet()) {
            classContainer = (ClassContainer)entry.getValue();
            for (String string : classContainer.implementsClass) {
                if (!((MainContext)this.mainContext).classes.containsKey(string)) {
                    throw new KayJamNotFoundException((Expression)classContainer, "class interface", string);
                }
                ClassContainer implementsClass = ((MainContext)this.mainContext).classes.get(string);
                for (Function function : implementsClass.functions) {
                    Function fun = this.findFunction(classContainer, function);
                    if (fun.returnType.name.equals(function.returnType.name)) continue;
                    throw new KayJamRuntimeException((Expression)fun, "Invalid return type");
                }
                classContainer.children.addAll(implementsClass.children);
            }
            if (classContainer.companion == null) continue;
            Context ctx = new Context((Container)classContainer.companion, (Context)this.mainContext, false);
            for (Expression child : classContainer.companion.children) {
                if (child.getClass() != Variable.class) continue;
                this.provide(child, ctx, ctx);
            }
            classContainer.companion.data.put("ctx", ctx);
        }
        return this.provide((Expression)container, this.mainContext, this.mainContext);
    }

    private Executor handleUse(Expression expression) throws KayJamRuntimeException {
        if (expression instanceof Array) {
            Array array = (Array)expression;
            Iterator iterator = array.values.iterator();
            if (iterator.hasNext()) {
                Expression value = (Expression)iterator.next();
                return this.handleUse(value);
            }
        } else if (expression instanceof Const) {
            return this.useGetFileListener.getFile(((Const)expression).value.toString());
        }
        throw new KayJamRuntimeException(expression, "Expected array or string value");
    }

    private Function findFunction(ClassContainer classContainer, Function function) throws KayJamRuntimeException {
        for (Function fun : classContainer.functions) {
            if (fun.arguments.size() != function.arguments.size() || !fun.name.equals(function.name)) continue;
            boolean args = true;
            for (int i = 0; i < fun.arguments.size(); ++i) {
                if (((Function.Argument)fun.arguments.get((int)i)).type.name.equals(((Function.Argument)function.arguments.get((int)i)).type.name)) continue;
                args = false;
                break;
            }
            if (!args) continue;
            return fun;
        }
        throw new KayJamRuntimeException((Expression)classContainer, "Function " + function.name + " not found from implements class");
    }

    public Executor setUseGetFileListener(UseGetFile useGetFileListener) {
        this.useGetFileListener = useGetFileListener;
        return this;
    }

    public static interface UseGetFile {
        public Executor getFile(String var1);
    }
}

