/*
 * Decompiled with CFR 0.152.
 */
package com.github.kayjamlang.executor.executors;

import com.github.kayjamlang.core.Expression;
import com.github.kayjamlang.core.Range;
import com.github.kayjamlang.core.expressions.OperationExpression;
import com.github.kayjamlang.core.provider.MainExpressionProvider;
import com.github.kayjamlang.executor.Context;
import com.github.kayjamlang.executor.MainContext;
import com.github.kayjamlang.executor.exceptions.KayJamRuntimeException;
import com.github.kayjamlang.executor.executors.ExpressionExecutor;
import java.util.Objects;

public class OperationExpressionExecutor
extends ExpressionExecutor<OperationExpression> {
    public Object provide(MainExpressionProvider<Object, Context, MainContext> mainProvider, Context context, Context argsContext, OperationExpression expression) throws Exception {
        if (expression.operation != null) {
            Object left = mainProvider.provide(expression.left, (Object)context, (Object)argsContext);
            Object right = mainProvider.provide(expression.right, (Object)context, (Object)argsContext);
            switch (expression.operation) {
                case PLUS: {
                    if (left instanceof String || right instanceof String) {
                        return left.toString() + right.toString();
                    }
                    if (!(left instanceof Number) || !(right instanceof Number)) break;
                    return ((Number)left).longValue() + ((Number)right).longValue();
                }
                case MINUS: {
                    if (!(left instanceof Number) || !(right instanceof Number)) break;
                    return ((Number)left).longValue() - ((Number)right).longValue();
                }
                case DIVISION: {
                    if (!(left instanceof Number) || !(right instanceof Number)) break;
                    return ((Number)left).longValue() / ((Number)right).longValue();
                }
                case MULTIPLY: {
                    if (!(left instanceof Number) || !(right instanceof Number)) break;
                    return ((Number)left).longValue() * ((Number)right).longValue();
                }
                case LESS_SIGN: {
                    if (!(left instanceof Number) || !(right instanceof Number)) break;
                    return ((Number)left).longValue() < ((Number)right).longValue();
                }
                case LESS_EQUALS_SIGN: {
                    if (!(left instanceof Number) || !(right instanceof Number)) break;
                    return ((Number)left).longValue() <= ((Number)right).longValue();
                }
                case GREATER_SIGN: {
                    if (!(left instanceof Number) || !(right instanceof Number)) break;
                    return ((Number)left).longValue() > ((Number)right).longValue();
                }
                case GREATER_EQUALS_SIGN: {
                    if (!(left instanceof Number) || !(right instanceof Number)) break;
                    return ((Number)left).longValue() >= ((Number)right).longValue();
                }
                case EQUALS: {
                    return Objects.equals(left, right);
                }
                case NOT_EQUALS: {
                    return !Objects.equals(left, right);
                }
                case OR: {
                    if (!(left instanceof Boolean) || !(right instanceof Boolean)) break;
                    return (Boolean)left != false || (Boolean)right != false;
                }
                case AND: {
                    if (!(left instanceof Boolean) || !(right instanceof Boolean)) break;
                    return (Boolean)left != false && (Boolean)right != false;
                }
                case RANGE: {
                    if (!(left instanceof Number) || !(right instanceof Number)) break;
                    long primaryValue = ((Number)left).longValue();
                    long secondaryValue = ((Number)right).longValue();
                    return new Range(Long.valueOf(primaryValue), Long.valueOf(secondaryValue), Long.valueOf(primaryValue > secondaryValue ? -1 : 1));
                }
            }
        } else {
            throw new KayJamRuntimeException((Expression)expression, "This operation in executor not released");
        }
        throw new KayJamRuntimeException((Expression)expression, "Invalid operation values");
    }
}

