/*
 * Decompiled with CFR 0.152.
 */
package com.github.kayjamlang.executor.libs;

import com.github.kayjamlang.core.Expression;
import com.github.kayjamlang.core.Type;
import com.github.kayjamlang.core.containers.ClassContainer;
import com.github.kayjamlang.core.containers.Function;
import com.github.kayjamlang.core.containers.ObjectContainer;
import com.github.kayjamlang.core.expressions.Const;
import com.github.kayjamlang.core.expressions.Return;
import com.github.kayjamlang.core.expressions.Variable;
import com.github.kayjamlang.core.opcodes.AccessIdentifier;
import com.github.kayjamlang.executor.Context;
import com.github.kayjamlang.executor.MainContext;
import com.github.kayjamlang.executor.exceptions.KayJamRuntimeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Library {
    public final List<LibFunction> functions = new ArrayList<LibFunction>();
    public final Map<String, ClassContainer> classes = new HashMap<String, ClassContainer>();

    public static class CodeExecExpression
    extends Expression {
        public final Code code;

        public CodeExecExpression(Code code) {
            super(AccessIdentifier.NONE, 0);
            this.code = code;
        }

        public static interface Code {
            public Object execute(MainContext var1, Context var2) throws KayJamRuntimeException, InterruptedException;
        }
    }

    public static class LibClass
    extends ClassContainer {
        public LibClass(String name, ClassBind binder) throws Exception {
            super(name, null, new ArrayList(), new ArrayList(), AccessIdentifier.NONE, 0);
            if (binder != null) {
                binder.bind(this);
            }
        }

        public void setCompanion(LibObject object) {
            this.companion = object;
        }

        public void addFunction(LibFunction function) {
            this.functions.add(function);
        }

        public void addVariable(String name, Object value) {
            this.children.add(new Variable(name, (Expression)new Const(value, 0), AccessIdentifier.PUBLIC, 0));
        }

        public static interface ClassBind {
            public void bind(LibClass var1);
        }
    }

    public static class LibObject
    extends ObjectContainer {
        public LibObject(ObjectBind binder) {
            super(new ArrayList(), AccessIdentifier.NONE, 0);
            if (binder != null) {
                binder.bind(this);
            }
        }

        public void addFunction(LibFunction function) {
            this.functions.add(function);
        }

        public void addVariable(String name, Object value) {
            this.children.add(new Variable(name, (Expression)new Const(value, 0), AccessIdentifier.PUBLIC, 0));
        }

        public static interface ObjectBind {
            public void bind(LibObject var1);
        }
    }

    public static class LibFunction
    extends Function {
        public LibFunction(String name, CodeExecExpression.Code code, Function.Argument ... arguments) {
            super(name, new ArrayList(), AccessIdentifier.NONE, Arrays.asList(arguments), 0, Type.ANY, new ArrayList());
            this.children.add(new Return((Expression)new CodeExecExpression(code), 0));
        }
    }
}

