/*
 * Decompiled with CFR 0.152.
 */
package com.github.lambdaexpression.filter;

import com.github.lambdaexpression.bean.MultiReadRequestBean;
import com.github.lambdaexpression.request.MultiReadHttpServletRequest;
import com.github.lambdaexpression.util.SpringBeanUtils;
import java.io.IOException;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.StringUtils;
import org.springframework.context.annotation.Import;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.GenericFilterBean;

@Component
@Import(value={SpringBeanUtils.class})
public class MultiReadRequestFilter
extends GenericFilterBean {
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.useMultiRead(request)) {
            MultiReadHttpServletRequest multiReadHttpServletRequest = new MultiReadHttpServletRequest((HttpServletRequest)request);
            chain.doFilter((ServletRequest)multiReadHttpServletRequest, response);
        } else {
            chain.doFilter(request, response);
        }
    }

    private boolean useMultiRead(ServletRequest request) {
        Map<String, MultiReadRequestBean> beans = SpringBeanUtils.getBeansOfType(MultiReadRequestBean.class);
        boolean use = !beans.isEmpty();
        for (String key : beans.keySet()) {
            if (beans.size() > 1 && StringUtils.equals((CharSequence)"defaultMultiReadRequestBean", (CharSequence)key) || beans.get(key).filter(request)) continue;
            use = false;
        }
        return use;
    }
}

