/*
 * Decompiled with CFR 0.152.
 */
package com.github.loicoudot.java4cpp;

import com.github.loicoudot.java4cpp.Analyzer;
import com.github.loicoudot.java4cpp.Context;
import com.github.loicoudot.java4cpp.Datatype;
import com.github.loicoudot.java4cpp.Java4Cpp;
import com.github.loicoudot.java4cpp.Java4CppNoWrappe;
import com.github.loicoudot.java4cpp.Java4CppWrappe;
import com.github.loicoudot.java4cpp.Utils;
import com.github.loicoudot.java4cpp.configuration.ClassMapping;
import com.github.loicoudot.java4cpp.model.ClassModel;
import com.github.loicoudot.java4cpp.model.ConstructorModel;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;

final class ConstructorsAnalyzer
extends Analyzer {
    public ConstructorsAnalyzer(Context context) {
        super(context);
    }

    @Override
    public void fill(ClassModel classModel) {
        for (Constructor<?> constructor : this.getConstructors(classModel.getType().getClazz())) {
            classModel.getContent().addConstructor(this.getModel(constructor));
        }
    }

    private List<Constructor<?>> getConstructors(Class<?> clazz) {
        ArrayList<Constructor<?>> list = Utils.newArrayList();
        for (Constructor<?> constructor : clazz.getConstructors()) {
            if (!this.isConstructorWrapped(constructor)) continue;
            list.add(constructor);
        }
        return list;
    }

    boolean isConstructorWrapped(Constructor<?> constructor) {
        ClassMapping mapping = this.mappings.get(constructor.getDeclaringClass());
        Java4Cpp annotation = constructor.getDeclaringClass().getAnnotation(Java4Cpp.class);
        if (mapping != null) {
            String name = Datatype.generateJNISignature(constructor.getParameterTypes());
            if (mapping.isExportAll().booleanValue()) {
                return !mapping.getConstructors().getNoWrappes().contains(name);
            }
            return mapping.getConstructors().findWrappe(name) != null;
        }
        if (annotation == null || annotation.all()) {
            return !constructor.isAnnotationPresent(Java4CppNoWrappe.class);
        }
        return constructor.isAnnotationPresent(Java4CppWrappe.class);
    }

    private ConstructorModel getModel(Constructor<?> constructor) {
        this.context.getFileManager().enter("constructor: " + constructor);
        ConstructorModel constructorModel = new ConstructorModel();
        constructorModel.getParameters().addAll(this.context.getClassesModels(constructor.getParameterTypes()));
        this.context.getFileManager().leave();
        return constructorModel;
    }
}

