/*
 * Decompiled with CFR 0.152.
 */
package com.github.loicoudot.java4cpp;

import com.github.loicoudot.java4cpp.Analyzer;
import com.github.loicoudot.java4cpp.ConstructorsAnalyzer;
import com.github.loicoudot.java4cpp.EnumAnalyzer;
import com.github.loicoudot.java4cpp.FieldsAnalyzer;
import com.github.loicoudot.java4cpp.FileManager;
import com.github.loicoudot.java4cpp.InnerClassAnalyzer;
import com.github.loicoudot.java4cpp.InterfacesAnalyzer;
import com.github.loicoudot.java4cpp.Java4Cpp;
import com.github.loicoudot.java4cpp.Java4CppClassLoader;
import com.github.loicoudot.java4cpp.Java4CppType;
import com.github.loicoudot.java4cpp.MappingsManager;
import com.github.loicoudot.java4cpp.MethodsAnalyzer;
import com.github.loicoudot.java4cpp.Settings;
import com.github.loicoudot.java4cpp.SuperclassAnalyzer;
import com.github.loicoudot.java4cpp.TemplateManager;
import com.github.loicoudot.java4cpp.TypeAnalyzer;
import com.github.loicoudot.java4cpp.TypeTemplates;
import com.github.loicoudot.java4cpp.Utils;
import com.github.loicoudot.java4cpp.model.ClassModel;
import com.github.loicoudot.java4cpp.model.ClassType;
import java.io.File;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public final class Context {
    private final Settings settings;
    private final FileManager fileManager;
    private final MappingsManager mappingsManager;
    private final TemplateManager templateManager;
    private Java4CppClassLoader classLoader = new Java4CppClassLoader();
    private final BlockingQueue<Java4CppType> classesToDo = new ArrayBlockingQueue<Java4CppType>(1024);
    private final List<Java4CppType> classesAlreadyDone = Utils.newArrayList();
    private final Map<Java4CppType, ClassModel> classModelCache = Utils.newHashMap();
    private final Analyzer[] analyzers;
    private final Analyzer typeAnalyzer;

    public Context(Settings settings) {
        this.settings = settings;
        this.fileManager = new FileManager(this);
        this.mappingsManager = new MappingsManager(this);
        this.templateManager = new TemplateManager(this);
        this.typeAnalyzer = new TypeAnalyzer(this);
        this.analyzers = new Analyzer[]{this.typeAnalyzer, new SuperclassAnalyzer(this), new InterfacesAnalyzer(this), new InnerClassAnalyzer(this), new FieldsAnalyzer(this), new EnumAnalyzer(this), new ConstructorsAnalyzer(this), new MethodsAnalyzer(this)};
    }

    public void start() {
        this.createClassLoader();
        this.getFileManager().start();
        this.getMappingsManager().start();
        this.addClassToDoFromJars();
        this.getTemplateManager().start();
    }

    public void stop() {
        this.getFileManager().stop();
    }

    private void createClassLoader() {
        if (!Utils.isNullOrEmpty(this.settings.getJarFiles())) {
            try {
                String[] files = this.settings.getJarFiles().split(";");
                ArrayList<URL> urls = Utils.newArrayList();
                for (String path : files) {
                    File file = new File(path);
                    if (!file.isFile()) continue;
                    urls.add(file.toURI().toURL());
                }
                this.classLoader = new Java4CppClassLoader(urls.toArray(new URL[files.length]), (ClassLoader)this.classLoader);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to load jar " + e.getMessage());
            }
        }
    }

    private void addClassToDoFromJars() {
        if (!Utils.isNullOrEmpty(this.settings.getJarFiles())) {
            try {
                String[] files;
                for (String path : files = this.settings.getJarFiles().split(";")) {
                    File file = new File(path);
                    if (!file.isFile()) {
                        String jarPath = this.classLoader.getJar(path);
                        if (jarPath == null) {
                            this.getFileManager().logInfo("can't find " + path);
                        }
                        file = new File(new URI(jarPath));
                    }
                    this.getFileManager().logInfo("searching classes to wrappe in " + file.getAbsolutePath());
                    JarFile jf = new JarFile(file);
                    Enumeration<JarEntry> entries = jf.entries();
                    while (entries.hasMoreElements()) {
                        Class<?> clazz;
                        String clName = entries.nextElement().getName();
                        if (!clName.endsWith(".class") || !(clazz = this.classLoader.loadClass(clName.split("\\.")[0].replace('/', '.'))).isAnnotationPresent(Java4Cpp.class)) continue;
                        this.addClassToDo(clazz);
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to load jar " + e.getMessage());
            }
        }
    }

    public void addClassToDo(Type type) {
        this.addClassToDo(Java4CppType.fromType(type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClassToDo(Java4CppType type) {
        BlockingQueue<Java4CppType> blockingQueue = this.classesToDo;
        synchronized (blockingQueue) {
            if (!this.classesAlreadyDone.contains(type) && !this.classesToDo.contains(type)) {
                this.classesToDo.add(type);
                this.classesAlreadyDone.add(type);
                this.getFileManager().logInfo("add dependency " + type);
            }
        }
    }

    public BlockingQueue<Java4CppType> getClassesToDo() {
        return this.classesToDo;
    }

    public boolean workToDo() {
        return !this.classesToDo.isEmpty();
    }

    public List<Java4CppType> getClassesAlreadyDone() {
        return this.classesAlreadyDone;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public FileManager getFileManager() {
        return this.fileManager;
    }

    public MappingsManager getMappingsManager() {
        return this.mappingsManager;
    }

    public TemplateManager getTemplateManager() {
        return this.templateManager;
    }

    public Class<?> loadClass(String clazz) {
        try {
            return this.classLoader.loadClass(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassModel analyzeClassModel(Java4CppType type) {
        try {
            this.getFileManager().enter("analyzing " + type);
            ClassModel classModel = this.getClassModel(type);
            if (this.getTemplateManager().getTypeTemplates(type.getRawClass()).isNeedAnalyzing()) {
                for (Analyzer analyzer : this.analyzers) {
                    analyzer.fill(classModel);
                }
            } else {
                this.typeAnalyzer.fill(classModel);
            }
            ClassModel classModel2 = classModel;
            return classModel2;
        }
        finally {
            this.getFileManager().leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassModel executeTypeTemplate(Java4CppType type) {
        try {
            this.getFileManager().enter("templating " + type);
            ClassModel classModel = this.getClassModel(type);
            ClassType typeModel = classModel.getType();
            TypeTemplates typeTemplates = this.getTemplateManager().getTypeTemplates(type.getRawClass());
            typeModel.setCppType(typeTemplates.getCppType(classModel));
            typeModel.setCppReturnType(typeTemplates.getCppReturnType(classModel));
            typeTemplates.executeDependencies(classModel);
            typeModel.setFunctions(typeTemplates.getFunctions(classModel));
            ClassModel classModel2 = classModel;
            return classModel2;
        }
        finally {
            this.getFileManager().leave();
        }
    }

    public ClassModel getClassModel(Type type) {
        return this.getClassModel(Java4CppType.fromType(type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassModel getClassModel(Java4CppType type) {
        if (!this.classModelCache.containsKey(type)) {
            Map<Java4CppType, ClassModel> map = this.classModelCache;
            synchronized (map) {
                if (!this.classModelCache.containsKey(type)) {
                    ClassModel classModel = new ClassModel(type);
                    this.classModelCache.put(type, classModel);
                    this.addClassToDo(type.getRawClass());
                    this.addClassToDo(type);
                    for (Java4CppType argumentType : type.getParameterizedTypes()) {
                        classModel.addParameter(this.getClassModel(argumentType));
                    }
                }
            }
        }
        return this.classModelCache.get(type);
    }

    public ClassModel getClassModel(String name) {
        try {
            return this.getClassModel(this.classLoader.loadClass(name));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Failed to load class " + e.getMessage());
        }
    }

    public List<ClassModel> getClassesModels(Type[] types) {
        ArrayList<ClassModel> result = Utils.newArrayList();
        for (Type type : types) {
            result.add(this.getClassModel(type));
        }
        return result;
    }
}

