/*
 * Decompiled with CFR 0.152.
 */
package com.github.loicoudot.java4cpp;

import com.github.loicoudot.java4cpp.Context;
import com.github.loicoudot.java4cpp.Java4CppType;
import com.github.loicoudot.java4cpp.ModelExecutor;
import com.github.loicoudot.java4cpp.Settings;
import com.github.loicoudot.java4cpp.SourceExecutor;
import com.github.loicoudot.java4cpp.SourceFormatter;
import com.github.loicoudot.java4cpp.Utils;
import com.github.loicoudot.java4cpp.model.ClassModel;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class Core {
    private static final float MILLISEC = 1000.0f;
    private static final int TIMEOUT = 20;
    private Context context;

    public static void main(String[] args) {
        new Core().execute(new Context(new Settings(args)));
    }

    public void execute(Context aContext) {
        this.context = aContext;
        this.context.start();
        Date startTime = new Date();
        this.context.getFileManager().logInfo(String.format("java4cpp version %s, starting at %s", Context.class.getPackage().getImplementationVersion(), startTime));
        this.analyzeModels();
        this.resolveTypeTemplates();
        this.generateSources();
        this.finalization();
        this.context.getFileManager().logInfo(String.format("elapsed time: %.3fs", Float.valueOf((float)(new Date().getTime() - startTime.getTime()) / 1000.0f)));
        this.context.stop();
    }

    private void analyzeModels() {
        try {
            do {
                ExecutorService pool = Executors.newFixedThreadPool(this.context.getSettings().getNbThread());
                while (this.context.workToDo()) {
                    pool.execute(new ModelExecutor(this.context));
                }
                pool.shutdown();
                while (!pool.isTerminated()) {
                    pool.awaitTermination(20L, TimeUnit.MILLISECONDS);
                }
            } while (this.context.workToDo());
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted " + e.getMessage());
        }
    }

    private void resolveTypeTemplates() {
        Collections.sort(this.context.getClassesAlreadyDone(), new Comparator<Java4CppType>(){

            @Override
            public int compare(Java4CppType t1, Java4CppType t2) {
                Class<?> o1 = t1.getRawClass();
                Class<?> o2 = t2.getRawClass();
                if (o1.isArray() && o2.isArray()) {
                    int idx2;
                    int idx1 = o1.getName().lastIndexOf(91);
                    if (idx1 == (idx2 = o2.getName().lastIndexOf(91))) {
                        return o1.getName().compareTo(o2.getName());
                    }
                    return idx1 < idx2 ? -1 : 1;
                }
                if (o1.isArray() && !o2.isArray()) {
                    return 1;
                }
                if (!o1.isArray() && o2.isArray()) {
                    return -1;
                }
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (Java4CppType type : this.context.getClassesAlreadyDone()) {
            this.context.executeTypeTemplate(type);
        }
    }

    private void generateSources() {
        try {
            ExecutorService pool = Executors.newFixedThreadPool(this.context.getSettings().getNbThread());
            for (Java4CppType type : this.context.getClassesAlreadyDone()) {
                Class<?> clazz = type.getRawClass();
                if (!this.isValid(clazz)) continue;
                pool.execute(new SourceExecutor(this.context, type));
            }
            pool.shutdown();
            while (!pool.isTerminated()) {
                pool.awaitTermination(20L, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted " + e.getMessage());
        }
    }

    private void finalization() {
        HashMap<String, Object> dataModel = Utils.newHashMap();
        dataModel.put("cppFormatter", new SourceFormatter());
        HashSet<ClassModel> dependencies = Utils.newHashSet();
        for (Java4CppType type : this.context.getClassesAlreadyDone()) {
            Class<?> clazz = type.getRawClass();
            if (!this.isValid(clazz)) continue;
            dependencies.add(this.context.getClassModel(clazz));
        }
        dataModel.put("classes", dependencies);
        dataModel.put("symbols", this.context.getFileManager().getSymbols().getSymbols());
        this.context.getTemplateManager().processGlobalTemplates(dataModel);
        this.context.getTemplateManager().copyFiles();
    }

    private boolean isValid(Class<?> clazz) {
        return !clazz.isPrimitive() && !clazz.isArray() && clazz.getEnclosingClass() == null;
    }
}

