/*
 * Decompiled with CFR 0.152.
 */
package com.github.loicoudot.java4cpp;

import com.github.loicoudot.java4cpp.Analyzer;
import com.github.loicoudot.java4cpp.Context;
import com.github.loicoudot.java4cpp.model.ClassModel;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class EnumAnalyzer
extends Analyzer {
    public EnumAnalyzer(Context context) {
        super(context);
    }

    @Override
    public void fill(ClassModel classModel) {
        for (String key : this.getEnumKeys(classModel.getType().getClazz())) {
            classModel.getContent().addEnumKey(key);
        }
    }

    private List<String> getEnumKeys(Class<?> clazz) {
        ArrayList<String> enumKeys = new ArrayList<String>();
        for (Field field : clazz.getFields()) {
            if (!field.isEnumConstant()) continue;
            enumKeys.add(this.mappings.escapeName(field.getName()));
        }
        return enumKeys;
    }
}

