/*
 * Decompiled with CFR 0.152.
 */
package com.github.loicoudot.java4cpp;

import com.github.loicoudot.java4cpp.Analyzer;
import com.github.loicoudot.java4cpp.Context;
import com.github.loicoudot.java4cpp.Java4Cpp;
import com.github.loicoudot.java4cpp.Java4CppNoWrappe;
import com.github.loicoudot.java4cpp.Java4CppWrappe;
import com.github.loicoudot.java4cpp.Utils;
import com.github.loicoudot.java4cpp.configuration.ClassMapping;
import com.github.loicoudot.java4cpp.configuration.Wrappe;
import com.github.loicoudot.java4cpp.model.ClassModel;
import com.github.loicoudot.java4cpp.model.FieldModel;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

final class FieldsAnalyzer
extends Analyzer {
    public FieldsAnalyzer(Context context) {
        super(context);
    }

    @Override
    public void fill(ClassModel classModel) {
        for (Field field : this.getStaticFields(classModel.getType().getClazz())) {
            classModel.getContent().addField(this.getModel(field));
        }
    }

    private List<Field> getStaticFields(Class<?> clazz) {
        ArrayList<Field> list = Utils.newArrayList();
        for (Field field : clazz.getDeclaredFields()) {
            int mod = field.getModifiers();
            if (!Modifier.isStatic(mod) || !Modifier.isPublic(mod) || !this.isFieldWrapped(field)) continue;
            list.add(field);
        }
        return list;
    }

    boolean isFieldWrapped(Field field) {
        ClassMapping mapping = this.mappings.get(field.getDeclaringClass());
        Java4Cpp annotation = field.getDeclaringClass().getAnnotation(Java4Cpp.class);
        if (mapping != null) {
            if (mapping.isExportFields().booleanValue()) {
                return !mapping.getStaticFields().getNoWrappes().contains(field.getName());
            }
            return mapping.getStaticFields().findWrappe(field.getName()) != null;
        }
        if (annotation != null && annotation.staticFields()) {
            return !field.isAnnotationPresent(Java4CppNoWrappe.class);
        }
        return field.isAnnotationPresent(Java4CppWrappe.class);
    }

    private FieldModel getModel(Field field) {
        this.context.getFileManager().enter("field: " + field);
        FieldModel fieldModel = new FieldModel(field.getName());
        fieldModel.setCppName(this.getCppName(field));
        fieldModel.setType(this.context.getClassModel(field.getType()));
        this.context.getFileManager().leave();
        return fieldModel;
    }

    String getCppName(Field field) {
        Wrappe wrappedField;
        ClassMapping mapping = this.mappings.get(field.getDeclaringClass());
        if (mapping != null && (wrappedField = mapping.getStaticFields().findWrappe(field.getName())) != null && !Utils.isNullOrEmpty(wrappedField.getCppName())) {
            return wrappedField.getCppName();
        }
        Java4CppWrappe annot = field.getAnnotation(Java4CppWrappe.class);
        if (annot != null && !Utils.isNullOrEmpty(annot.value())) {
            return annot.value();
        }
        return this.mappings.escapeName(field.getName());
    }
}

