/*
 * Decompiled with CFR 0.152.
 */
package com.github.loicoudot.java4cpp;

import com.github.loicoudot.java4cpp.Context;
import com.github.loicoudot.java4cpp.Utils;
import com.github.loicoudot.java4cpp.configuration.Symbols;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.xml.bind.JAXB;

final class FileManager {
    private static final String JAVA4CPP_HASH = "java4cpp.hash";
    private static final String JAVA4CPP_LOG = "java4cpp.log";
    private static final int BUFFER_SIZE = 1024;
    private final Context context;
    private final ThreadLocal<String> indent = new ThreadLocal<String>(){

        @Override
        protected String initialValue() {
            return "";
        }
    };
    private FileWriter java4cppLog;
    private File java4cppHash;
    private final Symbols imports = new Symbols();
    private final Symbols export = new Symbols();
    private List<File> oldFiles = new ArrayList<File>();
    private final Properties oldHashes = new Properties();
    private final Properties newHashes = new Properties();
    private int generated;
    private int skipped;
    private int deleted;
    private int imported;

    public FileManager(Context context) {
        this.context = context;
    }

    public void start() {
        this.addSymbolsFromSettings();
        File rep = new File(this.context.getSettings().getTargetPath());
        rep.mkdirs();
        try {
            this.java4cppLog = new FileWriter(new File(this.getPath(JAVA4CPP_LOG)));
        }
        catch (IOException e) {
            System.err.println("Can't create log file: " + e.getMessage());
        }
        try {
            File[] existings = rep.listFiles(new SourceFilter());
            if (existings != null) {
                this.oldFiles = new ArrayList<File>(Arrays.asList(existings));
            }
            this.java4cppHash = new File(this.getPath(JAVA4CPP_HASH));
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.java4cppHash));
            this.oldHashes.load(in);
            in.close();
            this.java4cppHash.delete();
        }
        catch (IOException e) {
            this.logInfo("no java4cpp.hash file, regenerating all files");
        }
    }

    private void addSymbolsFromSettings() {
        if (!Utils.isNullOrEmpty(this.context.getSettings().getImportsFile())) {
            Symbols imported = new Symbols();
            for (String name : this.context.getSettings().getImportsFile().split(";")) {
                try {
                    InputStream is = Utils.getFileOrResource(name);
                    Symbols symbol = (Symbols)JAXB.unmarshal((InputStream)is, Symbols.class);
                    is.close();
                    imported.getSymbols().addAll(symbol.getSymbols());
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to read imports: " + e.getMessage());
                }
            }
            if (Utils.isNullOrEmpty(this.context.getSettings().getImportFilter())) {
                this.imports.getSymbols().addAll(imported.getSymbols());
            } else {
                Pattern regex = Pattern.compile(this.context.getSettings().getImportFilter());
                for (String symbol : imported.getSymbols()) {
                    if (!regex.matcher(symbol).matches()) continue;
                    this.imports.getSymbols().add(symbol);
                }
            }
        }
    }

    public void stop() {
        if (!Utils.isNullOrEmpty(this.context.getSettings().getExportFile())) {
            if (Utils.isNullOrEmpty(this.context.getSettings().getExportFilter())) {
                JAXB.marshal((Object)this.export, (File)new File(this.context.getSettings().getExportFile()));
            } else {
                Symbols exportFiltered = new Symbols();
                Pattern regexp = Pattern.compile(this.context.getSettings().getExportFilter());
                for (String symbol : this.export.getSymbols()) {
                    if (!regexp.matcher(symbol).matches()) continue;
                    exportFiltered.getSymbols().add(symbol);
                }
                JAXB.marshal((Object)exportFiltered, (File)new File(this.context.getSettings().getExportFile()));
            }
        }
        if (this.context.getSettings().isClean()) {
            for (File file : this.oldFiles) {
                this.logInfo("deleting " + file.getName());
                if (!file.delete()) {
                    this.logInfo("failed");
                }
                ++this.deleted;
            }
        }
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.java4cppHash));
            this.newHashes.store(out, "Generated by java4cpp");
            out.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to generate java4cpp.hash " + e.getMessage());
        }
        this.logInfo(String.format("generated: %d, imported: %d, skipped: %d, deleted: %d", this.generated, this.imported, this.skipped, this.deleted));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enter(String message) {
        FileWriter fileWriter = this.java4cppLog;
        synchronized (fileWriter) {
            try {
                this.java4cppLog.append('[').append(Thread.currentThread().getName()).append("] ");
                this.java4cppLog.append(this.indent.get()).append(message).append('\n');
                this.java4cppLog.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.indent.set(this.indent.get() + "  ");
    }

    public void leave() {
        this.indent.set(this.indent.get().substring(2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logInfo(String message) {
        FileWriter fileWriter = this.java4cppLog;
        synchronized (fileWriter) {
            try {
                this.java4cppLog.append('[').append(Thread.currentThread().getName()).append("] ");
                this.java4cppLog.append(this.indent.get()).append(message).append('\n');
                this.java4cppLog.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void writeSourceFile(String fileName, StringWriter sw) {
        this.saveFile(new String(sw.getBuffer()), new File(this.getPath(fileName)));
    }

    public void copyFile(String fileName) throws IOException {
        String content = this.readFile(Utils.getFileOrResource(fileName));
        this.saveFile(content, new File(this.getPath(fileName)));
    }

    public Symbols getSymbols() {
        return this.export;
    }

    private synchronized void saveFile(String fileContent, File fileName) {
        try {
            if (this.imports.getSymbols().contains(fileName.getName())) {
                this.logInfo("   imported " + fileName);
                ++this.imported;
            } else {
                this.export.getSymbols().add(fileName.getName());
                MessageDigest algo = MessageDigest.getInstance("MD5");
                algo.update(fileContent.getBytes());
                String md5 = FileManager.bytesToHexString(algo.digest());
                this.newHashes.put(fileName.getName(), md5);
                if (!(this.context.getSettings().isUseHash() && this.oldFiles.contains(fileName) && md5.equals(this.oldHashes.getProperty(fileName.getName())))) {
                    fileName.setWritable(true);
                    BufferedOutputStream writer = new BufferedOutputStream(new FileOutputStream(fileName));
                    writer.write(fileContent.getBytes());
                    fileName.setWritable(false);
                    writer.close();
                    ++this.generated;
                    this.logInfo("   generated " + fileName);
                } else {
                    ++this.skipped;
                    this.logInfo("   skipped " + fileName);
                }
                this.oldFiles.remove(fileName);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to save file " + e.getMessage());
        }
    }

    private String getPath(String fileName) {
        return String.format("%s%s%s", this.context.getSettings().getTargetPath(), File.separator, fileName);
    }

    private String readFile(InputStream input) throws IOException {
        int numRead;
        StringBuilder sb = new StringBuilder(1024);
        InputStreamReader reader = new InputStreamReader(input);
        char[] chars = new char[1024];
        while ((numRead = reader.read(chars)) > -1) {
            sb.append((CharSequence)String.valueOf(chars, 0, numRead));
        }
        ((Reader)reader).close();
        return ((Object)sb).toString();
    }

    private static String bytesToHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        Formatter formatter = new Formatter(sb);
        for (byte b : bytes) {
            formatter.format("%02X", b);
        }
        formatter.close();
        return sb.toString();
    }

    final class SourceFilter
    implements FilenameFilter {
        SourceFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return !name.equalsIgnoreCase(FileManager.JAVA4CPP_LOG) && !name.equalsIgnoreCase(FileManager.JAVA4CPP_HASH);
        }
    }
}

