/*
 * Decompiled with CFR 0.152.
 */
package com.github.loicoudot.java4cpp;

import com.github.loicoudot.java4cpp.Analyzer;
import com.github.loicoudot.java4cpp.Context;
import com.github.loicoudot.java4cpp.Java4Cpp;
import com.github.loicoudot.java4cpp.Java4CppNoWrappe;
import com.github.loicoudot.java4cpp.Java4CppWrappe;
import com.github.loicoudot.java4cpp.Utils;
import com.github.loicoudot.java4cpp.configuration.ClassMapping;
import com.github.loicoudot.java4cpp.model.ClassModel;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

public class InnerClassAnalyzer
extends Analyzer {
    public InnerClassAnalyzer(Context context) {
        super(context);
    }

    @Override
    public void fill(ClassModel classModel) {
        for (Class<?> nestedClass : this.getNestedClasses(classModel.getType().getClazz())) {
            classModel.getContent().addNestedClass(this.context.getClassModel(nestedClass));
        }
    }

    private List<Class<?>> getNestedClasses(Class<?> clazz) {
        ArrayList<Class<?>> list = Utils.newArrayList();
        for (Class<?> nested : clazz.getDeclaredClasses()) {
            if (!Modifier.isPublic(nested.getModifiers()) || !this.isInnerClassWrapped(clazz, nested)) continue;
            list.add(nested);
        }
        return list;
    }

    boolean isInnerClassWrapped(Class<?> clazz, Class<?> innerClass) {
        ClassMapping mapping = this.mappings.get(clazz);
        Java4Cpp annotation = clazz.getAnnotation(Java4Cpp.class);
        if (mapping != null) {
            String name = innerClass.getName().substring(innerClass.getName().indexOf(36) + 1);
            if (mapping.isExportAll().booleanValue()) {
                return !mapping.getInnerClasses().getNoWrappes().contains(name);
            }
            return mapping.getInnerClasses().findWrappe(name) != null;
        }
        if (annotation == null || annotation.all()) {
            return !innerClass.isAnnotationPresent(Java4CppNoWrappe.class);
        }
        return innerClass.isAnnotationPresent(Java4CppWrappe.class);
    }
}

