/*
 * Decompiled with CFR 0.152.
 */
package com.github.loicoudot.java4cpp;

import com.github.loicoudot.java4cpp.Analyzer;
import com.github.loicoudot.java4cpp.Context;
import com.github.loicoudot.java4cpp.Java4Cpp;
import com.github.loicoudot.java4cpp.Utils;
import com.github.loicoudot.java4cpp.configuration.ClassMapping;
import com.github.loicoudot.java4cpp.model.ClassModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class InterfacesAnalyzer
extends Analyzer {
    public InterfacesAnalyzer(Context context) {
        super(context);
    }

    @Override
    public void fill(ClassModel classModel) {
        for (Class<?> interfac : this.getInterfaces(classModel.getType().getClazz())) {
            classModel.getContent().addInterface(this.context.getClassModel(interfac));
        }
    }

    private List<Class<?>> getInterfaces(Class<?> clazz) {
        ArrayList<Class<?>> interfaces = Utils.newArrayList();
        for (Class<?> interfac : clazz.getInterfaces()) {
            if (interfac == Cloneable.class || !this.isInterfaceWrapped(clazz, interfac)) continue;
            interfaces.add(interfac);
        }
        return interfaces;
    }

    boolean isInterfaceWrapped(Class<?> clazz, Class<?> interfac) {
        ClassMapping mapping = this.mappings.get(clazz);
        Java4Cpp annotation = clazz.getAnnotation(Java4Cpp.class);
        if (mapping != null) {
            if (mapping.isInterfaceAll().booleanValue()) {
                return !mapping.getInterfaces().getNoWrappes().contains(interfac.getName());
            }
            return mapping.getInterfaces().findWrappe(interfac.getName()) != null;
        }
        if (annotation != null) {
            if (annotation.interfaces()) {
                return !Arrays.asList(annotation.noWrappeInterfaces()).contains(interfac);
            }
            return Arrays.asList(annotation.wrappeInterfaces()).contains(interfac);
        }
        return false;
    }
}

