/*
 * Decompiled with CFR 0.152.
 */
package com.github.loicoudot.java4cpp;

import com.github.loicoudot.java4cpp.Utils;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.List;

public class Java4CppType {
    private final Class<?> rawClass;
    private final List<Java4CppType> parameterizedTypes = Utils.newArrayList();
    private static List<Java4CppType> typeCache = Utils.newArrayList();

    public static Java4CppType fromType(Type type) {
        Java4CppType j4cType = new Java4CppType(type);
        int index = typeCache.indexOf(j4cType);
        if (index == -1) {
            typeCache.add(j4cType);
            return j4cType;
        }
        return typeCache.get(index);
    }

    private Java4CppType(Type type) {
        this.rawClass = Java4CppType.getRawClass(type);
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            for (Type argumentType : parameterizedType.getActualTypeArguments()) {
                this.parameterizedTypes.add(new Java4CppType(argumentType));
            }
        }
    }

    public Class<?> getRawClass() {
        return this.rawClass;
    }

    public List<Java4CppType> getParameterizedTypes() {
        return this.parameterizedTypes;
    }

    private static Class<?> getRawClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof TypeVariable) {
            return Java4CppType.getRawClass(((TypeVariable)type).getBounds()[0]);
        }
        if (type instanceof ParameterizedType) {
            return Java4CppType.getRawClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            return Java4CppType.getRawClass(((GenericArrayType)type).getGenericComponentType());
        }
        if (type instanceof WildcardType) {
            return Java4CppType.getRawClass(((WildcardType)type).getUpperBounds()[0]);
        }
        throw new RuntimeException("Can't get raw class from " + type);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.parameterizedTypes == null ? 0 : this.parameterizedTypes.hashCode());
        result = 31 * result + (this.rawClass == null ? 0 : this.rawClass.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Java4CppType other = (Java4CppType)obj;
        if (this.parameterizedTypes == null ? other.parameterizedTypes != null : !this.parameterizedTypes.equals(other.parameterizedTypes)) {
            return false;
        }
        return !(this.rawClass == null ? other.rawClass != null : !this.rawClass.equals(other.rawClass));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.rawClass.getName());
        if (!this.parameterizedTypes.isEmpty()) {
            String separator = "<";
            for (Java4CppType type : this.parameterizedTypes) {
                sb.append(separator);
                sb.append(type.toString());
                separator = ", ";
            }
            sb.append('>');
        }
        return sb.toString();
    }
}

