/*
 * Decompiled with CFR 0.152.
 */
package com.github.loicoudot.java4cpp;

import com.github.loicoudot.java4cpp.Context;
import com.github.loicoudot.java4cpp.Java4Cpp;
import com.github.loicoudot.java4cpp.Utils;
import com.github.loicoudot.java4cpp.configuration.ClassMapping;
import com.github.loicoudot.java4cpp.configuration.Mappings;
import com.github.loicoudot.java4cpp.configuration.Namespace;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXB;

public class MappingsManager {
    private final Context context;
    private final Mappings mappings = new Mappings();
    private final Map<Class<?>, ClassMapping> mappingCache = Utils.newHashMap();

    public MappingsManager(Context context) {
        this.context = context;
    }

    public void start() {
        this.addMappingsFromSettings();
        this.addClassToDoFromMappings();
    }

    private void addMappingsFromSettings() {
        if (!Utils.isNullOrEmpty(this.context.getSettings().getMappingsFile())) {
            for (String name : this.context.getSettings().getMappingsFile().split(";")) {
                try {
                    InputStream is = Utils.getFileOrResource(name);
                    Mappings mapping = (Mappings)JAXB.unmarshal((InputStream)is, Mappings.class);
                    is.close();
                    this.addMappings(mapping);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to read mappings from settings " + e.getMessage());
                }
            }
        }
    }

    private void addClassToDoFromMappings() {
        this.context.getFileManager().logInfo("adding classes to wrappe from mappings files");
        for (ClassMapping mapping : this.mappings.getClasses()) {
            Class<?> clazz = this.context.loadClass(mapping.getClazz());
            this.context.addClassToDo(clazz);
            this.mappingCache.put(clazz, mapping);
        }
    }

    public void addMappings(Mappings other) {
        this.mappings.getKeywords().addAll(other.getKeywords());
        this.mappings.getClasses().addAll(other.getClasses());
        this.mappings.getNamespaces().addAll(other.getNamespaces());
    }

    public String escapeName(String name) {
        if (this.mappings.getKeywords().contains(name)) {
            return this.escapeName(name + '_');
        }
        return name;
    }

    private List<String> getNamespaceMapping(Class<?> clazz) {
        int bestScore = 0;
        String bestNamespace = clazz.getName().replaceAll("\\.", "::");
        for (Namespace namespace : this.mappings.getNamespaces()) {
            if (namespace.getJavaPackage().length() <= bestScore || !clazz.getName().matches(namespace.getJavaPackage())) continue;
            bestScore = namespace.getJavaPackage().length();
            bestNamespace = Utils.isNullOrEmpty(namespace.getNamespace()) ? clazz.getSimpleName() : String.format("%s::%s", namespace.getNamespace(), clazz.getSimpleName());
        }
        return Arrays.asList(bestNamespace.split("::"));
    }

    public List<String> getNamespace(Class<?> clazz) {
        List<String> namespace;
        if (clazz.getEnclosingClass() == null) {
            namespace = this.getNamespaceMapping(clazz);
        } else {
            Class<?> enclosing = clazz;
            ArrayDeque stack = new ArrayDeque();
            while (enclosing.getEnclosingClass() != null) {
                stack.add(enclosing);
                enclosing = enclosing.getEnclosingClass();
            }
            namespace = this.getNamespace(enclosing);
            while (!stack.isEmpty()) {
                namespace.add(this.getCppName((Class)stack.pollLast()));
            }
        }
        ArrayList<String> escapedNamespace = Utils.newArrayList();
        for (String name : namespace) {
            escapedNamespace.add(this.escapeName(name));
        }
        escapedNamespace.set(escapedNamespace.size() - 1, this.getCppName(clazz));
        return escapedNamespace;
    }

    public String getCppName(Class<?> clazz) {
        ClassMapping mapping = this.mappingCache.get(clazz);
        Java4Cpp annotation = clazz.getAnnotation(Java4Cpp.class);
        if (mapping != null && !Utils.isNullOrEmpty(mapping.getCppName())) {
            return mapping.getCppName();
        }
        if (annotation != null && !Utils.isNullOrEmpty(annotation.name())) {
            return annotation.name();
        }
        return this.escapeName(clazz.getSimpleName());
    }

    public ClassMapping get(Class<?> clazz) {
        return this.mappingCache.get(clazz);
    }
}

