/*
 * Decompiled with CFR 0.152.
 */
package com.github.loicoudot.java4cpp;

import com.github.loicoudot.java4cpp.Analyzer;
import com.github.loicoudot.java4cpp.Context;
import com.github.loicoudot.java4cpp.Datatype;
import com.github.loicoudot.java4cpp.Java4Cpp;
import com.github.loicoudot.java4cpp.Java4CppNoWrappe;
import com.github.loicoudot.java4cpp.Java4CppWrappe;
import com.github.loicoudot.java4cpp.Utils;
import com.github.loicoudot.java4cpp.configuration.ClassMapping;
import com.github.loicoudot.java4cpp.configuration.Wrappe;
import com.github.loicoudot.java4cpp.model.ClassModel;
import com.github.loicoudot.java4cpp.model.MethodModel;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

final class MethodsAnalyzer
extends Analyzer {
    public MethodsAnalyzer(Context context) {
        super(context);
    }

    @Override
    public void fill(ClassModel classModel) {
        for (Method method : this.getMethods(classModel.getType().getClazz())) {
            classModel.getContent().addMethod(this.getModel(method));
        }
    }

    private List<Method> getMethods(Class<?> clazz) {
        ArrayList<Method> list = Utils.newArrayList();
        for (Method method : clazz.getDeclaredMethods()) {
            if (!Modifier.isPublic(method.getModifiers()) || method.isSynthetic() || method.getName().equals("clone") || !this.isMethodWrapped(method)) continue;
            list.add(method);
        }
        return list;
    }

    boolean isMethodWrapped(Method method) {
        ClassMapping mapping = this.mappings.get(method.getDeclaringClass());
        Java4Cpp annotation = method.getDeclaringClass().getAnnotation(Java4Cpp.class);
        if (mapping != null) {
            String name = method.getName() + "(" + Datatype.generateJNISignature(method.getParameterTypes()) + ")";
            if (mapping.isExportAll().booleanValue()) {
                return !mapping.getMethods().getNoWrappes().contains(name);
            }
            return mapping.getMethods().findWrappe(name) != null;
        }
        if (annotation == null || annotation.all()) {
            return !method.isAnnotationPresent(Java4CppNoWrappe.class);
        }
        return method.isAnnotationPresent(Java4CppWrappe.class);
    }

    private MethodModel getModel(Method method) {
        this.context.getFileManager().enter("method: " + method);
        MethodModel methodModel = new MethodModel(method.getName());
        methodModel.setCppName(this.getCppName(method));
        methodModel.setStatic(Modifier.isStatic(method.getModifiers()));
        methodModel.setReturnType(this.context.getClassModel(method.getGenericReturnType()));
        methodModel.getParameters().addAll(this.context.getClassesModels(method.getParameterTypes()));
        this.context.getFileManager().leave();
        return methodModel;
    }

    String getCppName(Method method) {
        Java4CppWrappe annot;
        ClassMapping mapping = this.mappings.get(method.getDeclaringClass());
        if (mapping != null) {
            String name = method.getName() + "(" + Datatype.generateJNISignature(method.getParameterTypes()) + ")";
            Wrappe wrappedMethod = mapping.getMethods().findWrappe(name);
            if (wrappedMethod != null && !Utils.isNullOrEmpty(wrappedMethod.getCppName())) {
                return wrappedMethod.getCppName();
            }
        }
        if ((annot = method.getAnnotation(Java4CppWrappe.class)) != null && !Utils.isNullOrEmpty(annot.value())) {
            return annot.value();
        }
        return this.mappings.escapeName(method.getName());
    }
}

