/*
 * Decompiled with CFR 0.152.
 */
package com.github.loicoudot.java4cpp;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public final class Settings {
    private static final String TARGET_PATH = "java4cpp.targetPath";
    private static final String JAR_FILES = "java4cpp.jarFiles";
    private static final String MAPPINGS_FILE = "java4cpp.mappingsFile";
    private static final String TEMPLATES_FILE = "java4cpp.templatesFile";
    private static final String CLEAN = "java4cpp.clean";
    private static final String USE_HASH = "java4cpp.useHash";
    private static final String NB_THREAD = "java4cpp.nbThread";
    private static final String EXPORT_FILE = "java4cpp.exportFile";
    private static final String EXPORT_FILTER = "java4cpp.exportFilter";
    private static final String IMPORTS_FILE = "java4cpp.importsFile";
    private static final String IMPORT_FILTER = "java4cpp.importFilter";
    private String targetPath;
    private String jarFiles;
    private String mappingsFile;
    private String templatesFile;
    private boolean clean;
    private boolean useHash;
    private int nbThread;
    private String exportFile;
    private String exportFilter;
    private String importsFile;
    private String importFilter;

    public Settings() {
        this.initFromProperties(System.getProperties());
    }

    public Settings(String propertiesFile) {
        this.initFromPropertiesFile(propertiesFile);
    }

    public Settings(String[] args) {
        if (args.length > 0) {
            this.initFromPropertiesFile(args[0]);
        } else {
            this.initFromProperties(System.getProperties());
        }
    }

    private void initFromProperties(Properties properties) {
        this.setTargetPath(properties.getProperty(TARGET_PATH, "."));
        this.setJarFiles(properties.getProperty(JAR_FILES, ""));
        this.setMappingsFile(properties.getProperty(MAPPINGS_FILE, ""));
        this.setTemplatesFile(properties.getProperty(TEMPLATES_FILE, ""));
        this.setClean(Boolean.valueOf(properties.getProperty(CLEAN, "false")));
        this.setUseHash(Boolean.valueOf(properties.getProperty(USE_HASH, "true")));
        this.setNbThread(Integer.valueOf(properties.getProperty(NB_THREAD, "1")));
        this.setExportFile(properties.getProperty(EXPORT_FILE, ""));
        this.setExportFilter(properties.getProperty(EXPORT_FILTER, ""));
        this.setImportsFile(properties.getProperty(IMPORTS_FILE, ""));
        this.setImportFilter(properties.getProperty(IMPORT_FILTER, ""));
    }

    private void initFromPropertiesFile(String propertiesFile) {
        Properties properties = (Properties)System.getProperties().clone();
        try {
            FileInputStream inStream = new FileInputStream(propertiesFile);
            properties.load(inStream);
            inStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read properties " + e.getMessage());
        }
        this.initFromProperties(properties);
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public void setTargetPath(String targetPath) {
        this.targetPath = targetPath;
    }

    public String getJarFiles() {
        return this.jarFiles;
    }

    public void setJarFiles(String jarFiles) {
        this.jarFiles = jarFiles;
    }

    public String getMappingsFile() {
        return this.mappingsFile;
    }

    public void setMappingsFile(String mappingsFile) {
        this.mappingsFile = mappingsFile;
    }

    public String getTemplatesFile() {
        return this.templatesFile;
    }

    public void setTemplatesFile(String templatesFile) {
        this.templatesFile = templatesFile;
    }

    public boolean isClean() {
        return this.clean;
    }

    public void setClean(boolean clean) {
        this.clean = clean;
    }

    public boolean isUseHash() {
        return this.useHash;
    }

    public void setUseHash(boolean useHash) {
        this.useHash = useHash;
    }

    public int getNbThread() {
        return this.nbThread;
    }

    public void setNbThread(int nbThread) {
        this.nbThread = nbThread;
    }

    public String getExportFile() {
        return this.exportFile;
    }

    public void setExportFile(String exportFile) {
        this.exportFile = exportFile;
    }

    public String getExportFilter() {
        return this.exportFilter;
    }

    public void setExportFilter(String exportFilter) {
        this.exportFilter = exportFilter;
    }

    public String getImportsFile() {
        return this.importsFile;
    }

    public void setImportsFile(String importsFile) {
        this.importsFile = importsFile;
    }

    public String getImportFilter() {
        return this.importFilter;
    }

    public void setImportFilter(String importFilter) {
        this.importFilter = importFilter;
    }
}

